/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.web.jboss.ClassLoadingMetaData;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.metadata.web.spec.WebMetaData;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class JBossWebAppParsingDeployer extends SchemaResolverDeployer<JBossWebMetaData>
/*     */ {
/*     */   public JBossWebAppParsingDeployer()
/*     */   {
/*  57 */     super(JBossWebMetaData.class);
/*  58 */     setInput(WebMetaData.class);
/*  59 */     setName("jboss-web.xml");
/*     */   }
/*     */ 
/*     */   public String getWebXmlPath()
/*     */   {
/*  70 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setWebXmlPath(String webXmlPath)
/*     */   {
/*  81 */     setName(webXmlPath);
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix)
/*     */     throws DeploymentException
/*     */   {
/*  87 */     super.createMetaData(unit, name, suffix);
/*     */ 
/*  89 */     WebMetaData specMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
/*  90 */     JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
/*  91 */     if ((specMetaData == null) && (metaData == null)) {
/*  92 */       return;
/*     */     }
/*     */ 
/*  95 */     if (metaData == null)
/*     */     {
/*  97 */       metaData = new JBossWebMetaData();
/*     */     }
/*     */ 
/* 100 */     JBossWebMetaData mergedMetaData = new JBossWebMetaData();
/* 101 */     mergedMetaData.merge(metaData, specMetaData);
/*     */ 
/* 103 */     unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, mergedMetaData);
/*     */ 
/* 105 */     unit.addAttachment("Raw" + JBossWebMetaData.class.getName(), metaData, JBossWebMetaData.class);
/*     */   }
/*     */ 
/*     */   protected void init(VFSDeploymentUnit unit, JBossWebMetaData metaData, VirtualFile file)
/*     */     throws Exception
/*     */   {
/* 112 */     ClassLoadingMetaData classLoading = metaData.getClassLoading();
/* 113 */     LoaderRepositoryMetaData lrmd = null;
/* 114 */     if (classLoading != null)
/* 115 */       lrmd = classLoading.getLoaderRepository();
/* 116 */     if (lrmd != null)
/*     */     {
/* 118 */       LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/*     */ 
/* 120 */       loaderConfig.repositoryClassName = lrmd.getLoaderRepositoryClass();
/* 121 */       loaderConfig.repositoryName = new ObjectName(lrmd.getName());
/* 122 */       Set configs = lrmd.getLoaderRepositoryConfig();
/* 123 */       if ((configs != null) && (!configs.isEmpty()))
/*     */       {
/* 125 */         LoaderRepositoryConfigMetaData config = (LoaderRepositoryConfigMetaData)configs.iterator().next();
/* 126 */         loaderConfig.configParserClassName = config.getConfigParserClass();
/* 127 */         loaderConfig.repositoryConfig = config.getConfig();
/*     */       }
/* 129 */       unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderConfig);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix, String key)
/*     */     throws DeploymentException
/*     */   {
/* 140 */     super.createMetaData(unit, name, suffix, key);
/*     */ 
/* 142 */     WebMetaData wmd = (WebMetaData)unit.getTransientManagedObjects().getAttachment(WebMetaData.class);
/* 143 */     JBossWebMetaData result = (JBossWebMetaData)unit.getTransientManagedObjects().getAttachment(getOutput());
/* 144 */     if ((result == null) && (wmd != null))
/*     */     {
/* 146 */       result = new JBossWebMetaData();
/* 147 */       result.merge(null, wmd);
/* 148 */       unit.getTransientManagedObjects().addAttachment(key, result, getOutput());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JBossWebAppParsingDeployer
 * JD-Core Version:    0.6.0
 */