/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
/*     */ import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
/*     */ import org.jboss.metadata.ear.jboss.JBossAppMetaData;
/*     */ import org.jboss.metadata.ear.spec.EarMetaData;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class JBossAppParsingDeployer extends SchemaResolverDeployer<JBossAppMetaData>
/*     */ {
/*  51 */   private boolean isolated = false;
/*     */ 
/*  53 */   private boolean callByValue = false;
/*     */ 
/*  55 */   private String unauthenticatedIdentity = null;
/*     */ 
/*     */   public JBossAppParsingDeployer()
/*     */   {
/*  62 */     super(JBossAppMetaData.class);
/*     */ 
/*  64 */     setName("jboss-app.xml");
/*     */   }
/*     */ 
/*     */   public String getAppXmlPath()
/*     */   {
/*  75 */     return getName();
/*     */   }
/*     */ 
/*     */   public void setAppXmlPath(String appXmlPath)
/*     */   {
/*  86 */     setName(appXmlPath);
/*     */   }
/*     */ 
/*     */   public boolean isIsolated()
/*     */   {
/*  94 */     return this.isolated;
/*     */   }
/*     */ 
/*     */   public void setIsolated(boolean isolated)
/*     */   {
/* 102 */     this.isolated = isolated;
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 110 */     return this.callByValue;
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 118 */     this.callByValue = callByValue;
/*     */   }
/*     */ 
/*     */   public String getUnauthenticatedIdentity()
/*     */   {
/* 128 */     return this.unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   public void setUnauthenticatedIdentity(String unauthenticatedIdentity)
/*     */   {
/* 137 */     this.unauthenticatedIdentity = unauthenticatedIdentity;
/*     */   }
/*     */ 
/*     */   protected void createMetaData(DeploymentUnit unit, String name, String suffix)
/*     */     throws DeploymentException
/*     */   {
/* 144 */     super.createMetaData(unit, name, suffix);
/* 145 */     EarMetaData specMetaData = (EarMetaData)unit.getAttachment(EarMetaData.class);
/* 146 */     JBossAppMetaData metaData = (JBossAppMetaData)unit.getAttachment(JBossAppMetaData.class);
/* 147 */     if ((specMetaData == null) && (metaData == null)) {
/* 148 */       return;
/*     */     }
/*     */ 
/* 151 */     if (metaData == null)
/*     */     {
/* 153 */       metaData = new JBossAppMetaData();
/*     */     }
/*     */ 
/* 156 */     JBossAppMetaData mergedMetaData = new JBossAppMetaData();
/* 157 */     mergedMetaData.merge(metaData, specMetaData);
/*     */ 
/* 159 */     unit.getTransientManagedObjects().addAttachment(JBossAppMetaData.class, mergedMetaData);
/*     */ 
/* 161 */     unit.addAttachment("Raw" + JBossAppMetaData.class.getName(), metaData, JBossAppMetaData.class);
/*     */   }
/*     */ 
/*     */   protected void init(VFSDeploymentUnit unit, JBossAppMetaData metaData, VirtualFile file)
/*     */     throws Exception
/*     */   {
/* 172 */     if (metaData != null)
/*     */     {
/* 174 */       LoaderRepositoryMetaData lrmd = metaData.getLoaderRepository();
/* 175 */       LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg = null;
/* 176 */       if ((loaderCfg == null) && (this.isolated))
/*     */       {
/* 179 */         loaderCfg = initLoaderRepository(metaData, unit);
/*     */       }
/* 181 */       if (lrmd != null)
/*     */       {
/* 183 */         loaderCfg = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/* 184 */         loaderCfg.repositoryClassName = lrmd.getLoaderRepositoryClass();
/* 185 */         loaderCfg.repositoryName = new ObjectName(lrmd.getName());
/* 186 */         Set configs = lrmd.getLoaderRepositoryConfig();
/* 187 */         if ((configs != null) && (!configs.isEmpty()))
/*     */         {
/* 189 */           LoaderRepositoryConfigMetaData config = (LoaderRepositoryConfigMetaData)configs.iterator().next();
/* 190 */           loaderCfg.configParserClassName = config.getConfigParserClass();
/* 191 */           loaderCfg.repositoryConfig = config.getConfig();
/*     */         }
/*     */       }
/*     */ 
/* 195 */       if (loaderCfg != null) {
/* 196 */         unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderCfg);
/*     */       }
/*     */     }
/* 199 */     if (this.callByValue) {
/* 200 */       unit.addAttachment("EAR.callByValue", Boolean.TRUE, Boolean.class);
/*     */     }
/* 202 */     if (this.unauthenticatedIdentity != null)
/* 203 */       unit.addAttachment("EAR.unauthenticatedIdentity", this.unauthenticatedIdentity, String.class);
/*     */   }
/*     */ 
/*     */   protected LoaderRepositoryFactory.LoaderRepositoryConfig initLoaderRepository(JBossAppMetaData metaData, DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 218 */       String name = EARDeployment.getJMXName(metaData, unit) + ",extension=LoaderRepository";
/* 219 */       ObjectName objectName = new ObjectName(name);
/* 220 */       LoaderRepositoryFactory.LoaderRepositoryConfig config = new LoaderRepositoryFactory.LoaderRepositoryConfig();
/* 221 */       config.repositoryName = objectName;
/* 222 */       return config;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 226 */     throw new DeploymentException("Failed to create LoaderRepositoryConfig", e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JBossAppParsingDeployer
 * JD-Core Version:    0.6.0
 */