/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileFilter;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.net.URLConnection;
/*     */ import java.util.Arrays;
/*     */ import java.util.Enumeration;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.Strings;
/*     */ 
/*     */ public class JARDeployer extends SubDeployerSupport
/*     */   implements JARDeployerMBean
/*     */ {
/*  58 */   private static final String[] DEFAULT_ENHANCED_SUFFIXES = { "700:.jar", "750:.zip", "900:.last" };
/*     */ 
/*  64 */   private String[] descriptorNames = { ".xml" };
/*     */ 
/*     */   public JARDeployer()
/*     */   {
/*  73 */     super.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
/*     */   }
/*     */ 
/*     */   public String[] getDescriptorNames()
/*     */   {
/*  78 */     return this.descriptorNames;
/*     */   }
/*     */ 
/*     */   public void setDescriptorNames(String[] descriptorNames)
/*     */   {
/*  83 */     this.descriptorNames = descriptorNames;
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean accepts(DeploymentInfo di)
/*     */   {
/* 109 */     boolean trace = this.log.isTraceEnabled();
/*     */     try
/*     */     {
/* 116 */       if ((di.shortName.indexOf('.') != -1) && (!super.accepts(di)))
/*     */       {
/* 118 */         return false;
/*     */       }
/*     */ 
/* 122 */       URL wdDir = di.localCl.findResource("WEB-INF/");
/* 123 */       if (wdDir != null)
/*     */       {
/* 125 */         return false;
/*     */       }
/*     */ 
/*     */       URL ddDir;
/*     */       try
/*     */       {
/* 137 */         ddDir = di.localCl.findResource("META-INF/");
/* 138 */         if (ddDir == null)
/*     */         {
/* 140 */           this.log.debug("No META-INF or WEB-INF resource found, assuming it if for us");
/* 141 */           return true;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ClassCastException e)
/*     */       {
/* 147 */         ddDir = new URL(di.url, "META-INF/");
/*     */       }
/*     */ 
/* 150 */       if (ddDir.getProtocol().equals("file"))
/*     */       {
/* 152 */         this.log.trace("File protocol: " + ddDir);
/* 153 */         File file = new File(ddDir.getFile());
/* 154 */         if (!file.exists())
/*     */         {
/* 156 */           this.log.warn("File not found: " + file);
/* 157 */           return true;
/*     */         }
/*     */ 
/* 161 */         File[] entries = file.listFiles(new FileFilter()
/*     */         {
/*     */           public boolean accept(File pathname)
/*     */           {
/* 166 */             boolean accept = false;
/* 167 */             String name = pathname.getName();
/* 168 */             for (int n = 0; (!accept) && (n < JARDeployer.this.descriptorNames.length); n++)
/*     */             {
/* 170 */               String d = JARDeployer.this.descriptorNames[n];
/* 171 */               accept = name.endsWith(d);
/*     */             }
/* 173 */             return accept;
/*     */           }
/*     */         });
/* 177 */         this.log.debug("XML entries found: " + entries.length);
/* 178 */         return entries.length == 0;
/*     */       }
/* 180 */       if (ddDir.getProtocol().equals("jar") == true)
/*     */       {
/* 182 */         this.log.trace("jar protocol: " + ddDir);
/* 183 */         JarFile jarFile = null;
/*     */         try
/*     */         {
/* 187 */           URLConnection con = ddDir.openConnection();
/* 188 */           jarConn = (JarURLConnection)con;
/*     */ 
/* 192 */           jarConn.setUseCaches(false);
/* 193 */           jarFile = jarConn.getJarFile();
/*     */ 
/* 196 */           if (trace)
/* 197 */             this.log.trace("Descriptor names=" + Arrays.asList(this.descriptorNames));
/* 198 */           for (e = jarFile.entries(); e.hasMoreElements(); )
/*     */           {
/* 200 */             JarEntry entry = (JarEntry)e.nextElement();
/* 201 */             String name = entry.getName();
/* 202 */             if (trace) {
/* 203 */               this.log.trace("Looking at entry: '" + name + "'");
/*     */             }
/*     */ 
/* 207 */             if ((name.startsWith("META-INF/")) && (Strings.count(name, "/") == 1))
/*     */             {
/*     */               int i;
/* 209 */               for (int n = 0; n < this.descriptorNames.length; n++)
/*     */               {
/* 211 */                 if (!name.endsWith(this.descriptorNames[n]))
/*     */                   continue;
/* 213 */                 this.log.debug("Found entry: '" + name + "', matching: '" + this.descriptorNames[n] + "', rejecting jar");
/*     */ 
/* 217 */                 i = 0; jsr 51;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */           JarURLConnection jarConn;
/*     */           Enumeration e;
/* 225 */           this.log.warn("Looking inside jar failed; ignoring", e);
/* 226 */           return 0;
/*     */         }
/*     */         finally
/*     */         {
/* 230 */           if (jarFile != null)
/* 231 */             jarFile.close();
/* 232 */           jarFile = null;
/*     */         }
/*     */ 
/* 235 */         this.log.debug("No xml files found");
/* 236 */         return true;
/*     */       }
/*     */ 
/* 240 */       this.log.debug("Unrecognized protocol: " + ddDir.getProtocol());
/*     */ 
/* 243 */       return false;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 247 */       this.log.trace("Ignored error", e);
/* 248 */     }return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.JARDeployer
 * JD-Core Version:    0.6.0
 */