/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class IncompleteDeploymentException extends DeploymentException
/*     */ {
/*     */   private static final long serialVersionUID = 1428860525880893167L;
/*     */   private final transient Collection mbeansWaitingForClasses;
/*     */   private final transient Collection mbeansWaitingForDepends;
/*     */   private final transient Collection rootCause;
/*     */   private final transient Collection incompletePackages;
/*     */   private final transient Collection waitingForDeployer;
/*     */   private String string;
/*     */ 
/*     */   public IncompleteDeploymentException(Collection mbeansWaitingForClasses, Collection mbeansWaitingForDepends, Collection rootCause, Collection incompletePackages, Collection waitingForDeployer)
/*     */   {
/*  67 */     if ((mbeansWaitingForClasses == null) || (mbeansWaitingForDepends == null) || (rootCause == null) || (incompletePackages == null) || (waitingForDeployer == null))
/*     */     {
/*  73 */       throw new IllegalArgumentException("All lists in IncompleteDeploymentException constructor must be supplied");
/*     */     }
/*     */ 
/*  76 */     this.mbeansWaitingForClasses = mbeansWaitingForClasses;
/*  77 */     this.mbeansWaitingForDepends = mbeansWaitingForDepends;
/*  78 */     this.rootCause = rootCause;
/*  79 */     this.incompletePackages = incompletePackages;
/*  80 */     this.waitingForDeployer = waitingForDeployer;
/*     */   }
/*     */ 
/*     */   public Collection getMbeansWaitingForClasses()
/*     */   {
/*  89 */     return this.mbeansWaitingForClasses;
/*     */   }
/*     */ 
/*     */   public Collection getMbeansWaitingForDepends()
/*     */   {
/*  98 */     return this.mbeansWaitingForDepends;
/*     */   }
/*     */ 
/*     */   public Collection getIncompletePackages()
/*     */   {
/* 107 */     return this.incompletePackages;
/*     */   }
/*     */ 
/*     */   public Collection getWaitingForDeployer()
/*     */   {
/* 116 */     return this.waitingForDeployer;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 124 */     return (this.mbeansWaitingForClasses.size() == 0) && (this.mbeansWaitingForDepends.size() == 0) && (this.rootCause.size() == 0) && (this.incompletePackages.size() == 0) && (this.waitingForDeployer.size() == 0);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 136 */     if (this.string != null)
/*     */     {
/* 138 */       return this.string;
/*     */     }
/*     */ 
/* 141 */     StringBuffer result = new StringBuffer("Incomplete Deployment listing:\n\n");
/* 142 */     if (this.waitingForDeployer.size() != 0)
/*     */     {
/* 144 */       result.append("--- Packages waiting for a deployer ---\n");
/* 145 */       appendCollection(result, this.waitingForDeployer);
/*     */     }
/*     */ 
/* 148 */     if (this.incompletePackages.size() != 0)
/*     */     {
/* 150 */       result.append("--- Incompletely deployed packages ---\n");
/* 151 */       appendCollection(result, this.incompletePackages);
/*     */     }
/*     */ 
/* 154 */     if (this.mbeansWaitingForClasses.size() != 0)
/*     */     {
/* 156 */       result.append("--- MBeans waiting for classes ---\n");
/* 157 */       appendCollection(result, this.mbeansWaitingForClasses);
/*     */     }
/*     */ 
/* 160 */     if (this.mbeansWaitingForDepends.size() != 0)
/*     */     {
/* 162 */       result.append("--- MBeans waiting for other MBeans ---\n");
/* 163 */       appendCollection(result, this.mbeansWaitingForDepends);
/*     */     }
/*     */ 
/* 166 */     if (this.rootCause.size() != 0)
/*     */     {
/* 168 */       result.append("--- MBEANS THAT ARE THE ROOT CAUSE OF THE PROBLEM ---\n");
/* 169 */       appendCollection(result, this.rootCause);
/*     */     }
/*     */ 
/* 172 */     this.string = result.toString();
/* 173 */     return this.string;
/*     */   }
/*     */ 
/*     */   private void appendCollection(StringBuffer result, Collection c)
/*     */   {
/* 178 */     for (Iterator i = c.iterator(); i.hasNext(); )
/* 179 */       result.append(i.next().toString()).append('\n');
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream s)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 187 */     s.defaultReadObject();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream s)
/*     */     throws IOException
/*     */   {
/* 195 */     toString();
/* 196 */     s.defaultWriteObject();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.IncompleteDeploymentException
 * JD-Core Version:    0.6.0
 */