/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.util.List;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Attributes.Name;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ear.jboss.JBossAppMetaData;
/*     */ import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.AbstractModule;
/*     */ import org.jboss.metadata.ear.spec.ConnectorModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.EarMetaData;
/*     */ import org.jboss.metadata.ear.spec.EjbModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.JavaModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModuleMetaData;
/*     */ import org.jboss.metadata.ear.spec.ModulesMetaData;
/*     */ import org.jboss.metadata.ear.spec.WebModuleMetaData;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
/*     */ 
/*     */ public class EARStructure extends AbstractStructureDeployer
/*     */ {
/*  66 */   public static final VirtualFileFilter DEFAULT_EAR_LIB_FILTER = new SuffixMatchFilter(".jar");
/*     */ 
/*  71 */   private VirtualFileFilter earLibFilter = DEFAULT_EAR_LIB_FILTER;
/*     */ 
/*  73 */   private SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
/*     */ 
/*     */   public EARStructure()
/*     */   {
/*  82 */     setRelativeOrder(1000);
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getEarLibFilter()
/*     */   {
/*  92 */     return this.earLibFilter;
/*     */   }
/*     */ 
/*     */   public void setEarLibFilter(VirtualFileFilter earLibFilter)
/*     */   {
/* 103 */     if (earLibFilter == null)
/* 104 */       throw new IllegalArgumentException("Null filter");
/* 105 */     this.earLibFilter = earLibFilter;
/*     */   }
/*     */ 
/*     */   public SchemaBindingResolver getResolver()
/*     */   {
/* 114 */     return this.resolver;
/*     */   }
/*     */ 
/*     */   public void setResolver(SchemaBindingResolver resolver)
/*     */   {
/* 122 */     this.resolver = resolver;
/*     */   }
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) {
/* 127 */     ContextInfo context = null;
/*     */ 
/* 129 */     boolean trace = this.log.isTraceEnabled();
/*     */     boolean valid;
/*     */     try { if ((file.isLeaf() == true) || (!file.getName().endsWith(".ear"))) {
/* 133 */         return false;
/*     */       }
/* 135 */       context = createContext(file, "META-INF", metaData);
/*     */ 
/* 137 */       VirtualFile applicationXml = getMetaDataFile(file, "META-INF/application.xml");
/* 138 */       VirtualFile jbossAppXml = getMetaDataFile(file, "META-INF/jboss-app.xml");
/*     */ 
/* 141 */       boolean scan = true;
/*     */ 
/* 143 */       UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/* 144 */       Unmarshaller unmarshaller = unmarshallerFactory.newUnmarshaller();
/* 145 */       EarMetaData specMetaData = null;
/* 146 */       JBossAppMetaData appMetaData = null;
/* 147 */       if (applicationXml != null)
/*     */       {
/* 149 */         InputStream in = applicationXml.openStream();
/*     */         try
/*     */         {
/* 152 */           specMetaData = (EarMetaData)unmarshaller.unmarshal(in, this.resolver);
/*     */         }
/*     */         finally
/*     */         {
/* 156 */           in.close();
/*     */         }
/* 158 */         scan = false;
/*     */       }
/* 160 */       if (jbossAppXml != null)
/*     */       {
/* 162 */         InputStream in = jbossAppXml.openStream();
/*     */         try
/*     */         {
/* 165 */           appMetaData = (JBossAppMetaData)unmarshaller.unmarshal(in, this.resolver);
/*     */         }
/*     */         finally
/*     */         {
/* 169 */           in.close();
/*     */         }
/*     */       }
/*     */ 
/* 173 */       if (appMetaData == null)
/*     */       {
/* 175 */         appMetaData = new JBossAppMetaData();
/*     */       }
/*     */ 
/* 178 */       appMetaData.merge(appMetaData, specMetaData);
/*     */ 
/* 181 */       String libDir = appMetaData.getLibraryDirectory() == null ? "lib" : appMetaData.getLibraryDirectory();
/* 182 */       if (trace)
/* 183 */         this.log.trace("Checking for ear lib directory: " + libDir);
/*     */       try
/*     */       {
/* 186 */         VirtualFile lib = file.findChild(libDir);
/* 187 */         if (lib != null)
/*     */         {
/* 189 */           if (trace)
/* 190 */             this.log.trace("Found ear lib directory: " + lib);
/* 191 */           List archives = lib.getChildren(this.earLibFilter);
/* 192 */           for (VirtualFile archive : archives)
/*     */           {
/* 194 */             super.addClassPath(root, archive, true, true, context);
/*     */             try
/*     */             {
/* 198 */               if (archive.findChild("META-INF/persistence.xml") != null)
/*     */               {
/* 200 */                 this.log.trace(archive.getName() + " in ear lib directory has persistence units");
/* 201 */                 if (!deployers.determineStructure(root, file, archive, metaData))
/*     */                 {
/* 203 */                   throw new RuntimeException(archive.getName() + " in lib directory has persistence.xml but is not a recognized deployment, .ear: " + file.getName());
/*     */                 }
/*     */ 
/*     */               }
/*     */ 
/*     */             }
/*     */             catch (IOException e)
/*     */             {
/* 212 */               if (trace) {
/* 213 */                 this.log.trace(archive.getPathName() + " does not contain META-INF/persistence.xml");
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/* 221 */         if (trace) {
/* 222 */           this.log.trace("Ignoring exception while searching for lib dir", ignored);
/*     */         }
/*     */       }
/*     */ 
/* 226 */       super.addClassPath(root, file, false, true, context);
/*     */ 
/* 229 */       if (scan)
/*     */       {
/* 231 */         scanEar(file, appMetaData);
/*     */       }
/*     */ 
/* 235 */       ModulesMetaData modules = appMetaData.getModules();
/* 236 */       if (modules != null) {
/* 237 */         for (ModuleMetaData mod : modules)
/*     */         {
/* 239 */           String fileName = mod.getFileName();
/* 240 */           if ((fileName != null) && ((fileName = fileName.trim()).length() > 0))
/*     */           {
/*     */             try
/*     */             {
/* 244 */               VirtualFile module = file.findChild(fileName);
/* 245 */               if (module == null)
/*     */               {
/* 247 */                 throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.getName());
/*     */               }
/*     */ 
/* 250 */               if (!deployers.determineStructure(root, file, module, metaData))
/*     */               {
/* 252 */                 throw new RuntimeException(fileName + " module listed in application.xml is not a recognized deployment, .ear: " + file.getName());
/*     */               }
/*     */ 
/*     */             }
/*     */             catch (IOException ignored)
/*     */             {
/* 259 */               throw new RuntimeException(fileName + " module listed in application.xml does not exist within .ear " + file.getName(), ignored);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/* 264 */       valid = true;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 268 */       throw new RuntimeException("Error determining structure: " + file.getName(), e);
/*     */     }
/*     */ 
/* 271 */     return valid;
/*     */   }
/*     */ 
/*     */   private void scanEar(VirtualFile root, JBossAppMetaData appMetaData)
/*     */     throws IOException
/*     */   {
/* 297 */     List archives = root.getChildren();
/*     */     String earPath;
/*     */     ModulesMetaData modules;
/* 298 */     if (archives != null)
/*     */     {
/* 300 */       earPath = root.getPathName();
/* 301 */       modules = appMetaData.getModules();
/* 302 */       if (modules == null)
/*     */       {
/* 304 */         modules = new ModulesMetaData();
/* 305 */         appMetaData.setModules(modules);
/*     */       }
/* 307 */       for (VirtualFile vfArchive : archives)
/*     */       {
/* 309 */         String filename = earRelativePath(earPath, vfArchive.getPathName());
/*     */ 
/* 311 */         ModuleMetaData moduleMetaData = appMetaData.getModule(filename);
/* 312 */         int type = typeFromSuffix(filename, vfArchive);
/* 313 */         if ((type >= 0) && (moduleMetaData == null))
/*     */         {
/* 315 */           moduleMetaData = new ModuleMetaData();
/* 316 */           AbstractModule module = null;
/* 317 */           switch (type)
/*     */           {
/*     */           case 0:
/* 320 */             module = new EjbModuleMetaData();
/* 321 */             break;
/*     */           case 2:
/* 323 */             module = new JavaModuleMetaData();
/* 324 */             break;
/*     */           case 3:
/* 326 */             module = new ConnectorModuleMetaData();
/* 327 */             break;
/*     */           case 4:
/*     */           case 5:
/* 330 */             module = new ServiceModuleMetaData();
/* 331 */             break;
/*     */           case 1:
/* 333 */             module = new WebModuleMetaData();
/*     */           }
/*     */ 
/* 336 */           module.setFileName(filename);
/* 337 */           moduleMetaData.setValue(module);
/* 338 */           modules.add(moduleMetaData);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private int typeFromSuffix(String path, VirtualFile archive)
/*     */     throws IOException
/*     */   {
/* 347 */     int type = -1;
/* 348 */     if (path.endsWith(".war")) {
/* 349 */       type = 1;
/* 350 */     } else if (path.endsWith(".rar")) {
/* 351 */       type = 3;
/* 352 */     } else if (path.endsWith(".har")) {
/* 353 */       type = 5;
/* 354 */     } else if (path.endsWith(".sar")) {
/* 355 */       type = 4;
/* 356 */     } else if (path.endsWith(".jar"))
/*     */     {
/* 359 */       VirtualFile mfFile = getMetaDataFile(archive, "META-INF/MANIFEST.MF");
/* 360 */       VirtualFile clientXml = getMetaDataFile(archive, "META-INF/application-client.xml");
/* 361 */       VirtualFile ejbXml = getMetaDataFile(archive, "META-INF/ejb-jar.xml");
/* 362 */       VirtualFile jbossXml = getMetaDataFile(archive, "META-INF/jboss.xml");
/*     */ 
/* 364 */       if (clientXml != null)
/*     */       {
/* 366 */         type = 2;
/*     */       }
/* 368 */       else if (mfFile != null)
/*     */       {
/* 370 */         Manifest mf = VFSUtils.readManifest(mfFile);
/* 371 */         Attributes attrs = mf.getMainAttributes();
/* 372 */         if (attrs.containsKey(Attributes.Name.MAIN_CLASS))
/*     */         {
/* 374 */           type = 2;
/*     */         }
/*     */         else
/*     */         {
/* 379 */           type = 0;
/*     */         }
/*     */       }
/* 382 */       else if ((ejbXml != null) || (jbossXml != null))
/*     */       {
/* 384 */         type = 0;
/*     */       }
/*     */       else
/*     */       {
/* 389 */         type = 0;
/*     */       }
/*     */     }
/*     */ 
/* 393 */     return type;
/*     */   }
/*     */ 
/*     */   private String earRelativePath(String earPath, String pathName)
/*     */   {
/* 398 */     StringBuilder tmp = new StringBuilder(pathName);
/* 399 */     tmp.delete(0, earPath.length());
/* 400 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   private VirtualFile getMetaDataFile(VirtualFile file, String path)
/*     */   {
/* 405 */     VirtualFile metaFile = null;
/*     */     try
/*     */     {
/* 408 */       metaFile = file.findChild(path);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*     */     }
/* 413 */     return metaFile;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.EARStructure
 * JD-Core Version:    0.6.0
 */