/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class DeploymentState
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -2319062412502366783L;
/*  38 */   public static final DeploymentState CONSTRUCTED = new DeploymentState("CONSTRUCTED");
/*  39 */   public static final DeploymentState INIT_WAITING_DEPLOYER = new DeploymentState("INIT_WAITING_DEPLOYER");
/*  40 */   public static final DeploymentState INIT_HAS_DEPLOYER = new DeploymentState("INIT_HAS_DEPLOYER");
/*  41 */   public static final DeploymentState INIT_DEPLOYER = new DeploymentState("INIT_DEPLOYER");
/*  42 */   public static final DeploymentState INITIALIZED = new DeploymentState("INITIALIZED");
/*     */ 
/*  44 */   public static final DeploymentState CREATE_SUBDEPLOYMENTS = new DeploymentState("CREATE_SUBDEPLOYMENTS");
/*  45 */   public static final DeploymentState CREATE_DEPLOYER = new DeploymentState("CREATE_DEPLOYER");
/*  46 */   public static final DeploymentState CREATED = new DeploymentState("CREATED");
/*     */ 
/*  48 */   public static final DeploymentState START_SUBDEPLOYMENTS = new DeploymentState("START_SUBDEPLOYMENTS");
/*  49 */   public static final DeploymentState START_DEPLOYER = new DeploymentState("START_DEPLOYER");
/*  50 */   public static final DeploymentState STARTED = new DeploymentState("STARTED");
/*     */ 
/*  52 */   public static final DeploymentState STOPPED = new DeploymentState("STOPPED");
/*  53 */   public static final DeploymentState DESTROYED = new DeploymentState("DESTROYED");
/*  54 */   public static final DeploymentState FAILED = new DeploymentState("FAILED");
/*     */   private String state;
/*     */ 
/*     */   private DeploymentState(String state)
/*     */   {
/*  62 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public static DeploymentState getDeploymentState(String state)
/*     */   {
/*  69 */     DeploymentState theState = null;
/*  70 */     state = state.toUpperCase();
/*  71 */     if (state.equals("CONSTRUCTED"))
/*  72 */       theState = CONSTRUCTED;
/*  73 */     else if (state.equals("INIT_WAITING_DEPLOYER"))
/*  74 */       theState = INIT_WAITING_DEPLOYER;
/*  75 */     else if (state.equals("INIT_HAS_DEPLOYER"))
/*  76 */       theState = INIT_HAS_DEPLOYER;
/*  77 */     else if (state.equals("INIT_DEPLOYER"))
/*  78 */       theState = INIT_DEPLOYER;
/*  79 */     else if (state.equals("INITIALIZED"))
/*  80 */       theState = INITIALIZED;
/*  81 */     else if (state.equals("CREATE_SUBDEPLOYMENTS"))
/*  82 */       theState = CREATE_SUBDEPLOYMENTS;
/*  83 */     else if (state.equals("CREATE_DEPLOYER"))
/*  84 */       theState = CREATE_DEPLOYER;
/*  85 */     else if (state.equals("CREATED"))
/*  86 */       theState = CREATED;
/*  87 */     else if (state.equals("START_SUBDEPLOYMENTS"))
/*  88 */       theState = START_SUBDEPLOYMENTS;
/*  89 */     else if (state.equals("START_DEPLOYER"))
/*  90 */       theState = START_DEPLOYER;
/*  91 */     else if (state.equals("STARTED"))
/*  92 */       theState = STARTED;
/*  93 */     else if (state.equals("STOPPED"))
/*  94 */       theState = STOPPED;
/*  95 */     else if (state.equals("DESTROYED"))
/*  96 */       theState = DESTROYED;
/*  97 */     else if (state.equals("FAILED")) {
/*  98 */       theState = FAILED;
/*     */     }
/* 100 */     return theState;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 105 */     return this.state;
/*     */   }
/*     */ 
/*     */   private Object readResolve()
/*     */     throws ObjectStreamException
/*     */   {
/* 112 */     Object identity = getDeploymentState(this.state);
/* 113 */     return identity;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.DeploymentState
 * JD-Core Version:    0.6.0
 */