/*     */ package org.jboss.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.net.URI;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VirtualFileVisitor;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ 
/*     */ public class AnnotatedClassFilter
/*     */   implements VirtualFileVisitor
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(AnnotatedClassFilter.class);
/*     */   private ClassLoader loader;
/*     */   private VirtualFile classpathRoot;
/*     */   private int rootLength;
/*  52 */   private HashSet<String> childPaths = new HashSet();
/*  53 */   private HashMap<VirtualFile, Class<?>> pathToClasses = new HashMap();
/*     */ 
/*     */   public AnnotatedClassFilter(VFSDeploymentUnit unit, ClassLoader loader, VirtualFile classpathRoot)
/*     */   {
/*  57 */     this.loader = loader;
/*  58 */     this.classpathRoot = classpathRoot;
/*     */ 
/*  61 */     String rootName = classpathRoot.getPathName();
/*  62 */     this.rootLength = rootName.length();
/*  63 */     if (this.rootLength > 0)
/*  64 */       this.rootLength += 1;
/*  65 */     List children = unit.getChildren();
/*  66 */     if (children != null)
/*     */     {
/*  68 */       for (DeploymentUnit cu : children)
/*     */       {
/*  70 */         String path = cu.getName();
/*  71 */         this.childPaths.add(path);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map<VirtualFile, Class<?>> getAnnotatedClasses()
/*     */   {
/*  78 */     return this.pathToClasses;
/*     */   }
/*     */ 
/*     */   public VisitorAttributes getAttributes()
/*     */   {
/*  83 */     VisitorAttributes attributes = new VisitorAttributes();
/*  84 */     attributes.setIncludeRoot(true);
/*  85 */     attributes.setRecurseFilter(new NoChildFilter());
/*  86 */     return attributes;
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFile file)
/*     */   {
/*     */     try
/*     */     {
/*  93 */       if (file.isLeaf())
/*     */       {
/*  95 */         accepts(file);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 100 */       throw new Error("Error visiting " + file, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean accepts(VirtualFile file)
/*     */   {
/* 106 */     boolean accepts = file.getPathName().endsWith(".class");
/* 107 */     if (accepts)
/*     */     {
/* 109 */       accepts = false;
/* 110 */       String className = null;
/*     */       try
/*     */       {
/* 113 */         className = getClassName(file);
/* 114 */         Class c = this.loader.loadClass(className);
/* 115 */         Annotation[] annotations = c.getAnnotations();
/* 116 */         if ((annotations != null) && (annotations.length > 0))
/*     */         {
/* 118 */           this.pathToClasses.put(file, c);
/* 119 */           accepts = true;
/*     */         }
/*     */       }
/*     */       catch (NoClassDefFoundError ignored)
/*     */       {
/* 124 */         log.debug("Incomplete class: " + className + ", NCDFE: " + ignored);
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/* 128 */         if (log.isTraceEnabled())
/* 129 */           log.trace("Failed to load class: " + className, ignored);
/*     */       }
/*     */     }
/* 132 */     return accepts;
/*     */   }
/*     */ 
/*     */   protected String getFilePath(VirtualFile file)
/*     */   {
/* 137 */     String path = null;
/*     */     try
/*     */     {
/* 140 */       path = file.toURI().toString();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 145 */     return path;
/*     */   }
/*     */ 
/*     */   protected String getClassName(VirtualFile classFile)
/*     */     throws IOException
/*     */   {
/* 156 */     String pathName = classFile.getPathName();
/* 157 */     String name = pathName.substring(this.rootLength, pathName.length() - 6);
/* 158 */     name = name.replace('/', '.');
/* 159 */     return name;
/*     */   }
/*     */   class NoChildFilter implements VirtualFileFilter {
/*     */     NoChildFilter() {
/*     */     }
/*     */ 
/*     */     public boolean accepts(VirtualFile file) {
/* 166 */       String path = AnnotatedClassFilter.this.getFilePath(file);
/* 167 */       boolean accepts = false;
/*     */       try
/*     */       {
/* 170 */         accepts = (!file.isLeaf()) && (!AnnotatedClassFilter.this.childPaths.contains(path));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/* 175 */       return accepts;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployment.AnnotatedClassFilter
 * JD-Core Version:    0.6.0
 */