/*     */ package org.jboss.deployers.vfs.spi.structure.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
/*     */ import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileVisitor;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ 
/*     */ public abstract class AbstractStructureDeployer
/*     */   implements StructureDeployer
/*     */ {
/*  51 */   protected Logger log = Logger.getLogger(getClass());
/*     */ 
/*  54 */   private int relativeOrder = 2147483647;
/*     */ 
/*  57 */   private CandidateStructureVisitorFactory candidateStructureVisitorFactory = DefaultCandidateStructureVisitorFactory.INSTANCE;
/*     */ 
/*     */   public static final String getRelativePath(VirtualFile parent, VirtualFile child)
/*     */   {
/*  68 */     if (child == null) {
/*  69 */       throw new IllegalArgumentException("Null child");
/*     */     }
/*  71 */     String childPath = child.getPathName();
/*  72 */     if (parent != null)
/*     */     {
/*  74 */       String parentPath = parent.getPathName();
/*     */ 
/*  76 */       if (parentPath.length() == childPath.length()) {
/*  77 */         return "";
/*     */       }
/*     */ 
/*  80 */       if (parentPath.length() < childPath.length())
/*     */       {
/*  82 */         if (!parentPath.endsWith("/"))
/*  83 */           parentPath = parentPath + "/";
/*  84 */         if (childPath.startsWith(parentPath)) {
/*  85 */           return childPath.substring(parentPath.length());
/*     */         }
/*     */       }
/*     */     }
/*  89 */     if (childPath.endsWith("/")) {
/*  90 */       childPath = childPath.substring(0, childPath.length() - 1);
/*     */     }
/*  92 */     return childPath;
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/*  97 */     return this.relativeOrder;
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int order)
/*     */   {
/* 102 */     this.relativeOrder = order;
/*     */   }
/*     */ 
/*     */   public CandidateStructureVisitorFactory getCandidateStructureVisitorFactory()
/*     */   {
/* 113 */     return this.candidateStructureVisitorFactory;
/*     */   }
/*     */ 
/*     */   public void setCandidateStructureVisitorFactory(CandidateStructureVisitorFactory candidateStructureVisitorFactory)
/*     */   {
/* 124 */     if (candidateStructureVisitorFactory == null)
/* 125 */       throw new IllegalArgumentException("Null candidateStructureVisitorFactory");
/* 126 */     this.candidateStructureVisitorFactory = candidateStructureVisitorFactory;
/*     */   }
/*     */ 
/*     */   public boolean isTopLevel(VirtualFile parent)
/*     */   {
/* 137 */     return parent == null;
/*     */   }
/*     */ 
/*     */   protected void addClassPath(VirtualFile root, VirtualFile entry, boolean includeEntry, boolean includeRootManifestCP, ContextInfo context)
/*     */     throws IOException
/*     */   {
/* 154 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 156 */     List paths = new ArrayList();
/*     */ 
/* 159 */     if (includeEntry) {
/* 160 */       paths.add(entry);
/*     */     }
/*     */ 
/* 163 */     if ((includeRootManifestCP) && (!isLeaf(entry)))
/*     */     {
/*     */       try
/*     */       {
/* 167 */         VFSUtils.addManifestLocations(entry, paths);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 171 */         if (trace) {
/* 172 */           this.log.trace("Failed to add manifest locations", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 177 */     for (VirtualFile vf : paths)
/*     */     {
/* 179 */       String entryPath = getRelativePath(root, vf);
/* 180 */       ClassPathEntry cpe = StructureMetaDataFactory.createClassPathEntry(entryPath);
/* 181 */       context.addClassPathEntry(cpe);
/* 182 */       if (trace)
/* 183 */         this.log.trace("Added classpath entry " + entryPath + " for " + vf.getName() + " from " + root);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addAllChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers)
/*     */     throws Exception
/*     */   {
/* 198 */     addChildren(root, parent, metaData, deployers, null);
/*     */   }
/*     */ 
/*     */   protected void addChildren(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes)
/*     */     throws Exception
/*     */   {
/* 213 */     if (parent == null) {
/* 214 */       throw new IllegalArgumentException("Null parent");
/*     */     }
/* 216 */     VirtualFileVisitor visitor = this.candidateStructureVisitorFactory.createVisitor(root, parent, metaData, deployers, attributes);
/* 217 */     parent.visit(visitor);
/*     */   }
/*     */ 
/*     */   protected boolean isLeaf(VirtualFile file)
/*     */     throws IOException
/*     */   {
/* 229 */     return SecurityActions.isLeaf(file);
/*     */   }
/*     */ 
/*     */   protected ContextInfo createContext(VirtualFile root, String metaDataPath, StructureMetaData structureMetaData)
/*     */   {
/* 243 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 245 */     if (root == null)
/* 246 */       throw new IllegalArgumentException("Null root");
/* 247 */     if (structureMetaData == null) {
/* 248 */       throw new IllegalArgumentException("Null structure metadata");
/*     */     }
/*     */ 
/* 251 */     if (metaDataPath != null)
/*     */     {
/*     */       try
/*     */       {
/* 255 */         root.findChild(metaDataPath);
/*     */       }
/*     */       catch (IOException ignored)
/*     */       {
/* 259 */         if (trace)
/* 260 */           this.log.trace("Not using metadata path " + metaDataPath + " for " + root.getName() + " reason: " + ignored.getMessage());
/* 261 */         metaDataPath = null;
/*     */       }
/*     */     }
/*     */     ContextInfo result;
/*     */     ContextInfo result;
/* 267 */     if (metaDataPath != null)
/* 268 */       result = StructureMetaDataFactory.createContextInfo("", metaDataPath, null);
/*     */     else
/* 270 */       result = StructureMetaDataFactory.createContextInfo("", null);
/* 271 */     structureMetaData.addContext(result);
/* 272 */     if (trace)
/* 273 */       this.log.trace("Added context " + result + " from " + root.getName());
/* 274 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer
 * JD-Core Version:    0.6.0
 */