/*     */ package org.jboss.deployers.vfs.spi.structure.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileVisitor;
/*     */ 
/*     */ public class AbstractCandidateStructureVisitor extends AbstractVirtualFileVisitor
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(AbstractCandidateStructureVisitor.class);
/*     */   private final VirtualFile root;
/*     */   private final VirtualFile parent;
/*     */   private final StructureMetaData metaData;
/*     */   private final VFSStructuralDeployers deployers;
/*     */   private boolean ignoreDirectories;
/*     */   private VirtualFileFilter filter;
/*     */ 
/*     */   public AbstractCandidateStructureVisitor(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers)
/*     */   {
/*  75 */     this(root, parent, metaData, deployers, null);
/*     */   }
/*     */ 
/*     */   public AbstractCandidateStructureVisitor(VirtualFile root, VirtualFile parent, StructureMetaData metaData, VFSStructuralDeployers deployers, VisitorAttributes attributes)
/*     */   {
/*  90 */     super(attributes);
/*  91 */     if (parent == null)
/*  92 */       throw new IllegalArgumentException("Null parent");
/*  93 */     this.root = root;
/*  94 */     this.parent = parent;
/*  95 */     this.metaData = metaData;
/*  96 */     this.deployers = deployers;
/*     */   }
/*     */ 
/*     */   public VirtualFile getParent()
/*     */   {
/* 106 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public boolean isIgnoreDirectories()
/*     */   {
/* 116 */     return this.ignoreDirectories;
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getFilter()
/*     */   {
/* 126 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public void setFilter(VirtualFileFilter filter)
/*     */   {
/* 136 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public void setIgnoreDirectories(boolean ignoreDirectories)
/*     */   {
/* 146 */     this.ignoreDirectories = ignoreDirectories;
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFile file)
/*     */   {
/* 151 */     String path = AbstractStructureDeployer.getRelativePath(this.parent, file);
/* 152 */     ContextInfo context = this.metaData.getContext(path);
/* 153 */     if (context == null)
/*     */     {
/*     */       try
/*     */       {
/* 158 */         if ((this.ignoreDirectories) && (!SecurityActions.isLeaf(file)))
/* 159 */           return;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 163 */         log.debug("Ignoring " + file + " reason=" + e);
/* 164 */         return;
/*     */       }
/*     */ 
/* 168 */       if ((this.filter != null) && (!this.filter.accepts(file))) {
/* 169 */         return;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 174 */         this.deployers.determineStructure(this.root, this.parent, file, this.metaData);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 178 */         log.debug("Ignoring " + file + " reason=" + e);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.structure.helpers.AbstractCandidateStructureVisitor
 * JD-Core Version:    0.6.0
 */