/*     */ package org.jboss.deployers.vfs.spi.deployer.helpers;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.io.OutputStream;
/*     */ import java.util.Map;
/*     */ import java.util.jar.Attributes;
/*     */ import java.util.jar.Manifest;
/*     */ import org.jboss.deployers.vfs.spi.deployer.ManifestMetaData;
/*     */ 
/*     */ public class AbstractManifestMetaData
/*     */   implements ManifestMetaData, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   protected transient Manifest manifest;
/*     */ 
/*     */   public AbstractManifestMetaData()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractManifestMetaData(Manifest manifest)
/*     */   {
/*  53 */     if (manifest == null)
/*  54 */       throw new IllegalArgumentException("Null manifest!");
/*  55 */     this.manifest = manifest;
/*     */   }
/*     */ 
/*     */   protected Manifest getManifest()
/*     */   {
/*  60 */     if (this.manifest == null)
/*  61 */       throw new IllegalArgumentException("Null manifest!");
/*  62 */     return this.manifest;
/*     */   }
/*     */ 
/*     */   protected String get(Attributes attributes, String name)
/*     */   {
/*  67 */     return attributes != null ? attributes.getValue(name) : null;
/*     */   }
/*     */ 
/*     */   public String getMainAttribute(String name)
/*     */   {
/*  72 */     return get(getManifest().getMainAttributes(), name);
/*     */   }
/*     */ 
/*     */   public String getAttribute(String attributesName, String name)
/*     */   {
/*  77 */     return get(getManifest().getAttributes(attributesName), name);
/*     */   }
/*     */ 
/*     */   public String getEntry(String entryName, String name)
/*     */   {
/*  82 */     Map entries = getManifest().getEntries();
/*  83 */     if (entries != null)
/*     */     {
/*  85 */       return get((Attributes)entries.get(entryName), name);
/*     */     }
/*  87 */     return null;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/*  92 */     OutputStream os = new OutputWrapper(out);
/*  93 */     getManifest().write(os);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  98 */     InputStream is = new InputWrapper(in);
/*  99 */     this.manifest = new Manifest(is);
/*     */   }
/*     */ 
/*     */   private class InputWrapper extends InputStream
/*     */   {
/*     */     private ObjectInput in;
/*     */ 
/*     */     public InputWrapper(ObjectInput in)
/*     */     {
/* 133 */       this.in = in;
/*     */     }
/*     */ 
/*     */     public int read() throws IOException
/*     */     {
/* 138 */       return this.in.read();
/*     */     }
/*     */ 
/*     */     public long skip(long n) throws IOException
/*     */     {
/* 143 */       return this.in.skip(n);
/*     */     }
/*     */ 
/*     */     public int available() throws IOException
/*     */     {
/* 148 */       return this.in.available();
/*     */     }
/*     */ 
/*     */     public void close() throws IOException
/*     */     {
/* 153 */       this.in.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private class OutputWrapper extends OutputStream
/*     */   {
/*     */     private ObjectOutput out;
/*     */ 
/*     */     public OutputWrapper(ObjectOutput out)
/*     */     {
/* 108 */       this.out = out;
/*     */     }
/*     */ 
/*     */     public void write(int b) throws IOException
/*     */     {
/* 113 */       this.out.write(b);
/*     */     }
/*     */ 
/*     */     public void flush() throws IOException
/*     */     {
/* 118 */       this.out.flush();
/*     */     }
/*     */ 
/*     */     public void close() throws IOException
/*     */     {
/* 123 */       this.out.close();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.helpers.AbstractManifestMetaData
 * JD-Core Version:    0.6.0
 */