/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Templates;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMResult;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.jboss.util.xml.JBossErrorHandler;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public abstract class XSLDeployer<T> extends JAXPDeployer<T>
/*     */ {
/*     */   protected String xslPath;
/*     */   private Templates templates;
/*     */ 
/*     */   public XSLDeployer(Class<T> deploymentType)
/*     */   {
/*  63 */     super(deploymentType);
/*     */   }
/*     */ 
/*     */   public String getXSLPath()
/*     */   {
/*  73 */     return this.xslPath;
/*     */   }
/*     */ 
/*     */   public void setXSLPath(String xslPath)
/*     */   {
/*  83 */     this.xslPath = xslPath;
/*     */   }
/*     */ 
/*     */   public Templates getTemplates()
/*     */   {
/*  94 */     if (this.templates == null)
/*  95 */       throw new IllegalStateException("Templates have not been constructed");
/*  96 */     return this.templates;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 106 */     super.create();
/*     */ 
/* 108 */     TransformerFactory tf = TransformerFactory.newInstance();
/*     */ 
/* 110 */     InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslPath);
/*     */     try
/*     */     {
/* 113 */       StreamSource ss = new StreamSource(is);
/* 114 */       ss.setSystemId(this.xslPath);
/* 115 */       this.templates = tf.newTemplates(ss);
/* 116 */       this.log.debug("Created templates: " + this.templates);
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 122 */         is.close();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 135 */     super.destroy();
/* 136 */     this.templates = null;
/*     */   }
/*     */ 
/*     */   protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root)
/*     */     throws Exception
/*     */   {
/* 142 */     if (file == null) {
/* 143 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 145 */     Document document = doParse(unit, file);
/*     */ 
/* 147 */     Transformer trans = getTemplates().newTransformer();
/* 148 */     trans.setErrorListener(new JBossErrorHandler(file.getPathName(), null));
/* 149 */     Source s = new DOMSource(document);
/* 150 */     DOMResult r = new DOMResult();
/* 151 */     setParameters(trans);
/*     */ 
/* 153 */     trans.transform(s, r);
/*     */ 
/* 155 */     document = (Document)r.getNode();
/* 156 */     String docStr = DOMWriter.printNode(document, true);
/* 157 */     this.log.debug("Transformed " + file.getPathName() + " into " + docStr);
/*     */ 
/* 159 */     return parse(unit, file, document);
/*     */   }
/*     */ 
/*     */   protected void setParameters(Transformer trans)
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected abstract T parse(VFSDeploymentUnit paramVFSDeploymentUnit, VirtualFile paramVirtualFile, Document paramDocument)
/*     */     throws Exception;
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.XSLDeployer
 * JD-Core Version:    0.6.0
 */