/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.xb.binding.ObjectModelFactory;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ 
/*     */ public abstract class ObjectModelFactoryDeployer<T> extends AbstractVFSParsingDeployer<T>
/*     */ {
/*  47 */   private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
/*     */ 
/*  50 */   private boolean useSchemaValidation = true;
/*     */ 
/*  53 */   private boolean useValidation = true;
/*     */ 
/*     */   public ObjectModelFactoryDeployer(Class<T> output)
/*     */   {
/*  63 */     super(output);
/*     */   }
/*     */ 
/*     */   public boolean isUseSchemaValidation()
/*     */   {
/*  73 */     return this.useSchemaValidation;
/*     */   }
/*     */ 
/*     */   public void setUseSchemaValidation(boolean useSchemaValidation)
/*     */   {
/*  83 */     this.useSchemaValidation = useSchemaValidation;
/*     */   }
/*     */ 
/*     */   public boolean isUseValidation()
/*     */   {
/*  93 */     return this.useValidation;
/*     */   }
/*     */ 
/*     */   public void setUseValidation(boolean useValidation)
/*     */   {
/* 103 */     this.useValidation = useValidation;
/*     */   }
/*     */ 
/*     */   protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root)
/*     */     throws Exception
/*     */   {
/* 109 */     if (file == null) {
/* 110 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 112 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 113 */     unmarshaller.setSchemaValidation(isUseSchemaValidation());
/* 114 */     unmarshaller.setValidation(isUseValidation());
/* 115 */     Object parsed = null;
/*     */     try
/*     */     {
/* 118 */       ObjectModelFactory factory = getObjectModelFactory(root);
/* 119 */       URL url = file.toURL();
/* 120 */       parsed = unmarshaller.unmarshal(url.toString(), factory, root);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 124 */       DeploymentException.rethrowAsDeploymentException("Error parsing meta data " + file.getPathName(), t);
/*     */     }
/* 126 */     if (parsed == null) {
/* 127 */       throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
/*     */     }
/* 129 */     return getOutput().cast(parsed);
/*     */   }
/*     */ 
/*     */   protected abstract ObjectModelFactory getObjectModelFactory(T paramT);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.ObjectModelFactoryDeployer
 * JD-Core Version:    0.6.0
 */