/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URI;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.Document;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public abstract class JAXPDeployer<T> extends AbstractVFSParsingDeployer<T>
/*     */ {
/*  50 */   private boolean useNamespaceAwareParser = true;
/*     */   private boolean validateDTDs;
/*     */   private DocumentBuilderFactory documentBuilderFactory;
/*     */ 
/*     */   public JAXPDeployer(Class<T> output)
/*     */   {
/*  66 */     super(output);
/*     */   }
/*     */ 
/*     */   public boolean isUseNamespaceAwareParser()
/*     */   {
/*  76 */     return this.useNamespaceAwareParser;
/*     */   }
/*     */ 
/*     */   public void setUseNamespaceAwareParser(boolean useNamespaceAwareParser)
/*     */   {
/*  86 */     this.useNamespaceAwareParser = useNamespaceAwareParser;
/*     */   }
/*     */ 
/*     */   public boolean isValidateDTDs()
/*     */   {
/*  96 */     return this.validateDTDs;
/*     */   }
/*     */ 
/*     */   public void setValidateDTDs(boolean validateDTDs)
/*     */   {
/* 106 */     this.validateDTDs = validateDTDs;
/*     */   }
/*     */ 
/*     */   protected DocumentBuilderFactory getDocumentBuilderFactory()
/*     */   {
/* 117 */     if (this.documentBuilderFactory == null)
/* 118 */       throw new IllegalStateException("Document builder factory has not been constructed");
/* 119 */     return this.documentBuilderFactory;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 129 */     this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
/* 130 */     this.documentBuilderFactory.setNamespaceAware(this.useNamespaceAwareParser);
/* 131 */     this.documentBuilderFactory.setValidating(this.validateDTDs);
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 139 */     this.documentBuilderFactory = null;
/*     */   }
/*     */ 
/*     */   protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root)
/*     */     throws Exception
/*     */   {
/* 146 */     Document document = (Document)unit.getAttachment(Document.class);
/* 147 */     if (document == null)
/*     */     {
/* 150 */       document = doParse(unit, file);
/*     */     }
/*     */ 
/* 154 */     return parse(unit, file, document);
/*     */   }
/*     */ 
/*     */   protected Document doParse(VFSDeploymentUnit unit, VirtualFile file)
/*     */     throws Exception
/*     */   {
/* 167 */     if (file == null) {
/* 168 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 170 */     this.log.trace("Parsing: " + file.getName());
/*     */ 
/* 172 */     InputStream is = SecurityActions.openStream(file);
/*     */     try
/*     */     {
/* 175 */       DocumentBuilder parser = getDocumentBuilderFactory().newDocumentBuilder();
/* 176 */       InputSource source = new InputSource(is);
/* 177 */       source.setSystemId(file.toURI().toString());
/* 178 */       parser.setEntityResolver(new JBossEntityResolver());
/* 179 */       Document localDocument = parser.parse(is);
/*     */       return localDocument;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 185 */         is.close();
/*     */       } catch (Exception ignored) {
/*     */       }
/*     */     }
/* 189 */     throw localObject;
/*     */   }
/*     */ 
/*     */   protected abstract T parse(VFSDeploymentUnit paramVFSDeploymentUnit, VirtualFile paramVirtualFile, Document paramDocument)
/*     */     throws Exception;
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.JAXPDeployer
 * JD-Core Version:    0.6.0
 */