/*     */ package org.jboss.deployers.vfs.spi.deployer;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URI;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.Unmarshaller;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.xml.sax.InputSource;
/*     */ 
/*     */ public abstract class JAXBDeployer<T> extends AbstractVFSParsingDeployer<T>
/*     */ {
/*     */   private JAXBContext context;
/*     */   private Map<String, Object> properties;
/*     */ 
/*     */   public JAXBDeployer(Class<T> output)
/*     */   {
/*  57 */     super(output);
/*     */   }
/*     */ 
/*     */   public Map<String, Object> getProperties()
/*     */   {
/*  67 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setProperties(Map<String, Object> properties)
/*     */   {
/*  77 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*  87 */     if (this.properties != null)
/*  88 */       this.context = JAXBContext.newInstance(new Class[] { getOutput() }, this.properties);
/*     */     else
/*  90 */       this.context = JAXBContext.newInstance(new Class[] { getOutput() });
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  98 */     this.context = null;
/*     */   }
/*     */ 
/*     */   protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root)
/*     */     throws Exception
/*     */   {
/* 104 */     Unmarshaller unmarshaller = this.context.createUnmarshaller();
/* 105 */     InputStream is = file.openStream();
/*     */     try
/*     */     {
/* 108 */       InputSource source = new InputSource(is);
/* 109 */       source.setSystemId(file.toURI().toString());
/* 110 */       Object o = unmarshaller.unmarshal(source);
/* 111 */       Object localObject1 = getOutput().cast(o);
/*     */       return localObject1;
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 117 */         is.close();
/*     */       } catch (Exception ignored) {
/*     */       }
/*     */     }
/* 121 */     throw localObject2;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.spi.deployer.JAXBDeployer
 * JD-Core Version:    0.6.0
 */