/*     */ package org.jboss.deployers.vfs.plugins.structure.war;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;
/*     */ 
/*     */ public class WARStructure extends AbstractStructureDeployer
/*     */ {
/*  46 */   public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
/*     */ 
/*  49 */   private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;
/*     */ 
/*     */   public WARStructure()
/*     */   {
/*  57 */     setRelativeOrder(1000);
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getWebInfLibFilter()
/*     */   {
/*  67 */     return this.webInfLibFilter;
/*     */   }
/*     */ 
/*     */   public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter)
/*     */   {
/*  78 */     if (webInfLibFilter == null)
/*  79 */       throw new IllegalArgumentException("Null filter");
/*  80 */     this.webInfLibFilter = webInfLibFilter;
/*     */   }
/*     */ 
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException
/*     */   {
/*  85 */     ContextInfo context = null;
/*     */     try
/*     */     {
/*  88 */       if (!isLeaf(file))
/*     */       {
/*  91 */         if (!file.getName().endsWith(".war"))
/*     */         {
/*     */           try
/*     */           {
/*  95 */             file.findChild("WEB-INF");
/*  96 */             this.log.trace("... ok - directory has a WEB-INF subdirectory");
/*     */           }
/*     */           catch (IOException e)
/*     */           {
/* 100 */             this.log.trace("... no - doesn't look like a war and no WEB-INF subdirectory.");
/* 101 */             return false;
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 106 */           this.log.trace("... ok - name ends in .war.");
/*     */         }
/*     */ 
/* 110 */         context = createContext(file, "WEB-INF", metaData);
/*     */ 
/* 113 */         addClassPath(root, file, false, true, context);
/*     */         try
/*     */         {
/* 117 */           VirtualFile classes = file.findChild("WEB-INF/classes");
/*     */ 
/* 119 */           addClassPath(root, classes, true, false, context);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 123 */           this.log.trace("No WEB-INF/classes for: " + file.getPathName());
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 128 */           VirtualFile webinfLib = file.findChild("WEB-INF/lib");
/* 129 */           List archives = webinfLib.getChildren(this.webInfLibFilter);
/* 130 */           for (VirtualFile jar : archives)
/* 131 */             addClassPath(root, jar, true, true, context);
/*     */         }
/*     */         catch (IOException ignored)
/*     */         {
/* 135 */           this.log.trace("No WEB-INF/lib for: " + file.getPathName());
/*     */         }
/*     */ 
/* 139 */         return true;
/*     */       }
/*     */ 
/* 143 */       this.log.trace("... no - not a directory or an archive.");
/* 144 */       return false;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 150 */       if (context != null)
/* 151 */         metaData.removeContext(context);
/*     */     }
/* 153 */     throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.war.WARStructure
 * JD-Core Version:    0.6.0
 */