/*     */ package org.jboss.deployers.vfs.plugins.structure.file;
/*     */ 
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ import org.jboss.beans.metadata.api.annotations.Install;
/*     */ import org.jboss.beans.metadata.api.annotations.Uninstall;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class FileStructure extends AbstractStructureDeployer
/*     */ {
/*  45 */   private static Set<String> fileSuffixes = new CopyOnWriteArraySet();
/*     */ 
/*  48 */   private Set<FileMatcher> fileMatchers = new CopyOnWriteArraySet();
/*     */ 
/*     */   public FileStructure()
/*     */   {
/*     */   }
/*     */ 
/*     */   public FileStructure(Set<String> suffixes)
/*     */   {
/*  74 */     if (suffixes == null)
/*  75 */       throw new IllegalArgumentException("Null suffixes");
/*  76 */     fileSuffixes.clear();
/*  77 */     fileSuffixes.addAll(suffixes);
/*     */   }
/*     */ 
/*     */   public Set<String> getSuffixes()
/*     */   {
/*  87 */     return fileSuffixes;
/*     */   }
/*     */ 
/*     */   public static boolean addFileSuffix(String suffix)
/*     */   {
/* 100 */     if (suffix == null)
/* 101 */       throw new IllegalArgumentException("Null suffix");
/* 102 */     return fileSuffixes.add(suffix);
/*     */   }
/*     */ 
/*     */   public static boolean removeFileSuffix(String suffix)
/*     */   {
/* 114 */     if (suffix == null)
/* 115 */       throw new IllegalArgumentException("Null suffix");
/* 116 */     return fileSuffixes.remove(suffix);
/*     */   }
/*     */ 
/*     */   @Install
/*     */   public boolean addFileMatcher(FileMatcher fm) {
/* 122 */     return this.fileMatchers.add(fm);
/*     */   }
/*     */ 
/*     */   @Uninstall
/*     */   public boolean removeFileMatcher(FileMatcher fm) {
/* 128 */     return this.fileMatchers.remove(fm);
/*     */   }
/*     */ 
/*     */   public static boolean isKnownFile(String name)
/*     */   {
/* 140 */     if (name == null) {
/* 141 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 143 */     for (String suffix : fileSuffixes)
/*     */     {
/* 145 */       if (name.endsWith(suffix))
/* 146 */         return true;
/*     */     }
/* 148 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean checkFileMatchers(VirtualFile file)
/*     */   {
/* 159 */     for (FileMatcher fm : this.fileMatchers)
/*     */     {
/* 161 */       if (fm.isDeployable(file))
/* 162 */         return true;
/*     */     }
/* 164 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException
/*     */   {
/* 169 */     ContextInfo context = null;
/*     */     try
/*     */     {
/* 172 */       boolean trace = this.log.isTraceEnabled();
/* 173 */       if (isLeaf(file) == true)
/*     */       {
/* 175 */         boolean isFile = false;
/* 176 */         if (trace) {
/* 177 */           this.log.trace(file + " is a leaf");
/*     */         }
/* 179 */         if (!isTopLevel(parent))
/*     */         {
/* 181 */           if ((!isKnownFile(file.getName())) && (!checkFileMatchers(file)))
/*     */           {
/* 183 */             if (trace)
/* 184 */               this.log.trace("... no - it is not a top level file and not a known name");
/*     */           }
/*     */           else
/*     */           {
/* 188 */             if (trace)
/* 189 */               this.log.trace("... ok - not a top level file but it is a known name");
/* 190 */             isFile = true;
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 195 */           if (trace)
/* 196 */             this.log.trace("... ok - it is a top level file");
/* 197 */           isFile = true;
/*     */         }
/*     */ 
/* 201 */         context = createContext(file, null, metaData);
/*     */ 
/* 203 */         if (trace)
/* 204 */           this.log.trace(file + " isFile: " + isFile);
/* 205 */         return isFile;
/*     */       }
/*     */ 
/* 209 */       if (trace)
/* 210 */         this.log.trace("... no - not a file.");
/* 211 */       return false;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 216 */       if (context != null)
/* 217 */         metaData.removeContext(context);
/*     */     }
/* 219 */     throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  53 */     fileSuffixes.add("-service.xml");
/*  54 */     fileSuffixes.add("-beans.xml");
/*  55 */     fileSuffixes.add("-ds.xml");
/*  56 */     fileSuffixes.add("-aop.xml");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.file.FileStructure
 * JD-Core Version:    0.6.0
 */