/*    */ package org.jboss.deployers.vfs.plugins.structure.explicit;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.net.URL;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*    */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.xb.binding.Unmarshaller;
/*    */ import org.jboss.xb.binding.UnmarshallerFactory;
/*    */ 
/*    */ public class DeclaredStructure extends AbstractStructureDeployer
/*    */ {
/*    */   public DeclaredStructure()
/*    */   {
/* 49 */     setRelativeOrder(0);
/*    */   }
/*    */ 
/*    */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException
/*    */   {
/*    */     try
/*    */     {
/* 56 */       boolean trace = this.log.isTraceEnabled();
/* 57 */       if (!isLeaf(file))
/*    */       {
/* 59 */         boolean isJBossStructure = false;
/* 60 */         if (trace)
/* 61 */           this.log.trace(file + " is not a leaf");
/*    */         try
/*    */         {
/* 64 */           VirtualFile jbossStructure = file.findChild("META-INF/jboss-structure.xml");
/* 65 */           this.log.trace("... context has a META-INF/jboss-structure.xml");
/* 66 */           URL url = jbossStructure.toURL();
/* 67 */           UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
/* 68 */           Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 69 */           StructureMetaDataObjectFactory ofactory = new StructureMetaDataObjectFactory();
/* 70 */           unmarshaller.unmarshal(url.toString(), ofactory, metaData);
/* 71 */           isJBossStructure = true;
/*    */         }
/*    */         catch (IOException e)
/*    */         {
/* 75 */           if (trace)
/* 76 */             this.log.trace("... no META-INF/jboss-structure.xml.");
/*    */         }
/* 78 */         if (trace)
/* 79 */           this.log.trace(file + " isJBossStructure: " + isJBossStructure);
/* 80 */         return isJBossStructure;
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 85 */       throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
/*    */     }
/* 87 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.explicit.DeclaredStructure
 * JD-Core Version:    0.6.0
 */