/*     */ package org.jboss.deployers.vfs.plugins.structure;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.TreeSet;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.Ordered;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
/*     */ import org.jboss.deployers.structure.spi.helpers.AbstractStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class VFSStructuralDeployersImpl extends AbstractStructuralDeployers
/*     */   implements VFSStructuralDeployers
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(VFSStructuralDeployersImpl.class);
/*     */ 
/*  57 */   private Set<StructureDeployer> structureDeployers = new TreeSet(Ordered.COMPARATOR);
/*     */ 
/*     */   public VFSStructuralDeployersImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public VFSStructuralDeployersImpl(Set<StructureDeployer> structureDeployers)
/*     */   {
/*  74 */     setDeployers(structureDeployers);
/*     */   }
/*     */ 
/*     */   public Set<StructureDeployer> getDeployers()
/*     */   {
/*  84 */     return this.structureDeployers;
/*     */   }
/*     */ 
/*     */   public void setDeployers(Set<StructureDeployer> deployers)
/*     */   {
/*  95 */     if (deployers == null) {
/*  96 */       throw new IllegalArgumentException("Null deployers");
/*     */     }
/*     */ 
/*  99 */     HashSet oldDeployers = new HashSet(this.structureDeployers);
/* 100 */     oldDeployers.removeAll(deployers);
/* 101 */     for (StructureDeployer deployer : oldDeployers) {
/* 102 */       removeDeployer(deployer);
/*     */     }
/*     */ 
/* 105 */     HashSet newDeployers = new HashSet(deployers);
/* 106 */     newDeployers.removeAll(this.structureDeployers);
/* 107 */     for (StructureDeployer deployer : newDeployers)
/* 108 */       addDeployer(deployer);
/*     */   }
/*     */ 
/*     */   public synchronized void addDeployer(StructureDeployer deployer)
/*     */   {
/* 118 */     if (deployer == null)
/* 119 */       throw new IllegalArgumentException("Null deployer");
/* 120 */     this.structureDeployers.add(new StructureDeployerWrapper(deployer));
/* 121 */     log.debug("Added structure deployer " + deployer);
/*     */   }
/*     */ 
/*     */   public synchronized void removeDeployer(StructureDeployer deployer)
/*     */   {
/* 131 */     if (deployer == null)
/* 132 */       throw new IllegalArgumentException("Null deployer");
/* 133 */     this.structureDeployers.remove(deployer);
/* 134 */     log.debug("Removed structure deployer " + deployer);
/*     */   }
/*     */ 
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData structureMetaData) throws DeploymentException
/*     */   {
/* 139 */     StructureMetaData structure = StructureMetaDataFactory.createStructureMetaData();
/* 140 */     boolean result = doDetermineStructure(root, parent, file, structure);
/* 141 */     if (result)
/*     */     {
/* 143 */       String relativePath = AbstractStructureDeployer.getRelativePath(parent, file);
/*     */ 
/* 146 */       ContextInfo recognised = structure.getContext("");
/* 147 */       if (recognised == null) {
/* 148 */         throw new IllegalStateException("Something recognised the deployment, but there is no context? " + file);
/*     */       }
/*     */ 
/* 152 */       List metaDataPath = recognised.getMetaDataPath();
/*     */       ContextInfo parentContext;
/*     */       ContextInfo parentContext;
/* 153 */       if ((metaDataPath == null) || (metaDataPath.isEmpty()))
/* 154 */         parentContext = StructureMetaDataFactory.createContextInfo(relativePath, recognised.getClassPath());
/*     */       else {
/* 156 */         parentContext = StructureMetaDataFactory.createContextInfo(relativePath, metaDataPath, recognised.getClassPath());
/*     */       }
/* 158 */       structureMetaData.addContext(parentContext);
/* 159 */       MutableAttachments attachments = (MutableAttachments)parentContext.getPredeterminedManagedObjects();
/* 160 */       attachments.addAttachment(StructureMetaData.class, structure);
/*     */     }
/* 162 */     return result;
/*     */   }
/*     */ 
/*     */   protected boolean doDetermineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData structureMetaData)
/*     */     throws DeploymentException
/*     */   {
/*     */     StructureDeployer[] theDeployers;
/* 178 */     synchronized (this)
/*     */     {
/* 180 */       if (this.structureDeployers.isEmpty()) {
/* 181 */         throw new IllegalStateException("No structure deployers");
/*     */       }
/* 183 */       theDeployers = (StructureDeployer[])this.structureDeployers.toArray(new StructureDeployer[this.structureDeployers.size()]);
/*     */     }
/*     */ 
/* 186 */     boolean trace = log.isTraceEnabled();
/* 187 */     if (trace) {
/* 188 */       log.trace("Determining structure for " + file.getName() + " deployers=" + Arrays.asList(theDeployers));
/*     */     }
/*     */ 
/* 191 */     boolean result = false;
/* 192 */     for (StructureDeployer deployer : theDeployers)
/*     */     {
/* 194 */       if (!deployer.determineStructure(root, parent, file, structureMetaData, this))
/*     */         continue;
/* 196 */       if (trace)
/* 197 */         log.trace(file.getName() + " recognised by " + deployer);
/* 198 */       result = true;
/* 199 */       break;
/*     */     }
/*     */ 
/* 202 */     if ((!result) && (trace))
/* 203 */       log.trace(file.getName() + " not recognised");
/* 204 */     return result;
/*     */   }
/*     */ 
/*     */   protected void determineStructure(Deployment deployment, StructureMetaData structure)
/*     */     throws Exception
/*     */   {
/* 210 */     if (!(deployment instanceof VFSDeployment)) {
/* 211 */       throw new DeploymentException("Structure can only be determined for VFSDeployments " + deployment);
/*     */     }
/* 213 */     VFSDeployment vfsDeployment = (VFSDeployment)deployment;
/*     */ 
/* 215 */     VirtualFile root = vfsDeployment.getRoot();
/* 216 */     if (root == null)
/* 217 */       throw new IllegalStateException("Deployment has no root " + deployment);
/* 218 */     if (!doDetermineStructure(root, null, root, structure))
/* 219 */       throw new DeploymentException("No deployer recognised the structure of " + deployment.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.VFSStructuralDeployersImpl
 * JD-Core Version:    0.6.0
 */