/*     */ package org.jboss.deployers.vfs.plugins.structure;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Vector;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class VFSDeploymentResourceLoaderImpl
/*     */   implements VFSDeploymentResourceLoader
/*     */ {
/*     */   private VirtualFile root;
/*     */ 
/*     */   public VFSDeploymentResourceLoaderImpl(VirtualFile root)
/*     */   {
/*  53 */     if (root == null)
/*  54 */       throw new IllegalArgumentException("Null root");
/*  55 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public VirtualFile getFile(String path)
/*     */   {
/*     */     try
/*     */     {
/*  62 */       return this.root.findChild(path);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/*  66 */     return null;
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/*     */     try
/*     */     {
/*  74 */       VirtualFile child = this.root.findChild(name);
/*  75 */       return child.toURL();
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*  79 */       return null;
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/*  83 */       return null;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/*  87 */     return null;
/*     */   }
/*     */ 
/*     */   public Enumeration<URL> getResources(String name)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/*  95 */       VirtualFile child = this.root.findChild(name);
/*  96 */       Vector vector = new Vector();
/*  97 */       vector.add(child.toURL());
/*  98 */       return vector.elements();
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/* 102 */       return null;
/*     */     }
/*     */     catch (MalformedURLException e) {
/*     */     }
/* 106 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.VFSDeploymentResourceLoaderImpl
 * JD-Core Version:    0.6.0
 */