/*     */ package org.jboss.deployers.vfs.plugins.structure;
/*     */ 
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class StructureDeployerWrapper
/*     */   implements StructureDeployer
/*     */ {
/*     */   private Logger log;
/*     */   private StructureDeployer deployer;
/*     */ 
/*     */   public StructureDeployerWrapper(StructureDeployer deployer)
/*     */   {
/*  54 */     if (deployer == null)
/*  55 */       throw new IllegalArgumentException("Null deployer");
/*  56 */     this.deployer = deployer;
/*  57 */     this.log = Logger.getLogger(deployer.getClass());
/*     */   }
/*     */ 
/*     */   public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException
/*     */   {
/*  62 */     if (file == null) {
/*  63 */       throw new IllegalArgumentException("Null file");
/*     */     }
/*  65 */     boolean result = this.deployer.determineStructure(root, parent, file, metaData, deployers);
/*  66 */     if (this.log.isTraceEnabled())
/*     */     {
/*  68 */       if (!result)
/*  69 */         this.log.trace("Not recognised: " + file.getName());
/*     */       else
/*  71 */         this.log.trace("Recognised: " + file.getName());
/*     */     }
/*  73 */     return result;
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/*  78 */     return this.deployer.getRelativeOrder();
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int order)
/*     */   {
/*  83 */     this.deployer.setRelativeOrder(order);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  89 */     if (obj == this)
/*  90 */       return true;
/*  91 */     if ((obj == null) || (!(obj instanceof StructureDeployer)))
/*  92 */       return false;
/*  93 */     if ((obj instanceof StructureDeployerWrapper))
/*  94 */       obj = ((StructureDeployerWrapper)obj).deployer;
/*  95 */     return this.deployer.equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 101 */     return this.deployer.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 107 */     return this.deployer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.StructureDeployerWrapper
 * JD-Core Version:    0.6.0
 */