/*    */ package org.jboss.deployers.vfs.plugins.structure;
/*    */ 
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.VirtualFileFilterWithAttributes;
/*    */ import org.jboss.virtual.VisitorAttributes;
/*    */ 
/*    */ public class MetaDataMatchFilter
/*    */   implements VirtualFileFilterWithAttributes
/*    */ {
/*    */   private String name;
/*    */   private String suffix;
/*    */   private VisitorAttributes attributes;
/*    */ 
/*    */   public MetaDataMatchFilter(String name, String suffix)
/*    */   {
/* 55 */     this(name, suffix, null);
/*    */   }
/*    */ 
/*    */   public MetaDataMatchFilter(String name, String suffix, VisitorAttributes attributes)
/*    */   {
/* 68 */     if ((name == null) && (suffix == null))
/* 69 */       throw new IllegalArgumentException("Null name and suffix");
/* 70 */     this.name = name;
/* 71 */     this.suffix = suffix;
/* 72 */     if (attributes == null)
/* 73 */       attributes = VisitorAttributes.LEAVES_ONLY;
/* 74 */     this.attributes = attributes;
/*    */   }
/*    */ 
/*    */   public VisitorAttributes getAttributes()
/*    */   {
/* 79 */     return this.attributes;
/*    */   }
/*    */ 
/*    */   public boolean accepts(VirtualFile file)
/*    */   {
/* 84 */     String fileName = file.getName();
/* 85 */     if ((this.name != null) && (fileName.equals(this.name)))
/* 86 */       return true;
/* 87 */     if (this.suffix != null)
/* 88 */       return fileName.endsWith(this.suffix);
/* 89 */     return false;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.structure.MetaDataMatchFilter
 * JD-Core Version:    0.6.0
 */