/*     */ package org.jboss.deployers.vfs.plugins.client;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.net.URI;
/*     */ import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class AbstractVFSDeployment extends AbstractDeployment
/*     */   implements VFSDeployment
/*     */ {
/*     */   private static final long serialVersionUID = 3992263833911364088L;
/*     */   private VirtualFile root;
/*     */ 
/*     */   static final String safeVirtualFileName(VirtualFile root)
/*     */   {
/*  54 */     if (root == null)
/*  55 */       throw new IllegalArgumentException("Null root");
/*     */     try
/*     */     {
/*  58 */       return root.toURI().toString();
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  62 */     return root.getName();
/*     */   }
/*     */ 
/*     */   public AbstractVFSDeployment()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractVFSDeployment(VirtualFile root)
/*     */   {
/*  81 */     super(safeVirtualFileName(root));
/*  82 */     this.root = root;
/*     */   }
/*     */ 
/*     */   public VirtualFile getRoot()
/*     */   {
/*  87 */     return this.root;
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/*  93 */     return this.root.getPathName();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 100 */     return "AbstractVFSDeployment(" + getSimpleName() + ")";
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 105 */     super.readExternal(in);
/* 106 */     this.root = ((VirtualFile)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 116 */     super.writeExternal(out);
/* 117 */     out.writeObject(this.root);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.plugins.client.AbstractVFSDeployment
 * JD-Core Version:    0.6.0
 */