/*     */ package org.jboss.deployers.vfs.deployer.kernel.managed;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.spi.factory.InstanceClassFactory;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ 
/*     */ public class BeanInstanceClassFactory
/*     */   implements InstanceClassFactory<AbstractBeanMetaData>
/*     */ {
/*  50 */   private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
/*     */ 
/*     */   protected ClassLoader getClassLoader(BeanMetaData beanMetaData)
/*     */   {
/*     */     try
/*     */     {
/*  63 */       return Configurator.getClassLoader(beanMetaData);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  67 */     throw new UndeclaredThrowableException(t);
/*     */   }
/*     */ 
/*     */   public Class<? extends Serializable> getManagedObjectClass(AbstractBeanMetaData attachment)
/*     */     throws ClassNotFoundException
/*     */   {
/*  74 */     return getClassLoader(attachment).loadClass(attachment.getBean());
/*     */   }
/*     */ 
/*     */   protected PropertyMetaData getPropertyMetaData(AbstractBeanMetaData attachment, String name)
/*     */   {
/*  86 */     PropertyMetaData propertyMetaData = null;
/*  87 */     Set properties = attachment.getProperties();
/*  88 */     if ((properties != null) && (!properties.isEmpty()))
/*     */     {
/*  90 */       for (PropertyMetaData pmd : properties)
/*     */       {
/*  92 */         if (name.equals(pmd.getName()))
/*     */         {
/*  94 */           propertyMetaData = pmd;
/*  95 */           break;
/*     */         }
/*     */       }
/*     */     }
/*  99 */     return propertyMetaData;
/*     */   }
/*     */ 
/*     */   protected PropertyMetaData getExactPropertyMetaData(AbstractBeanMetaData attachment, String name)
/*     */   {
/* 112 */     PropertyMetaData propertyMetaData = getPropertyMetaData(attachment, name);
/* 113 */     if (propertyMetaData == null)
/* 114 */       throw new IllegalArgumentException("No matching property meta data: " + name + "/" + attachment);
/* 115 */     return propertyMetaData;
/*     */   }
/*     */ 
/*     */   public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, AbstractBeanMetaData attachment)
/*     */   {
/* 120 */     String name = property.getName();
/* 121 */     PropertyMetaData pmd = getExactPropertyMetaData(attachment, name);
/* 122 */     PropertyInfo propertyInfo = beanInfo.getProperty(name);
/* 123 */     ValueMetaData valueMetaData = pmd.getValue();
/*     */     try
/*     */     {
/* 126 */       Object value = valueMetaData.getValue(propertyInfo.getType(), getClassLoader(attachment));
/* 127 */       return this.metaValueFactory.create(value, propertyInfo.getType());
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 131 */     throw new UndeclaredThrowableException(t);
/*     */   }
/*     */ 
/*     */   public void setValue(BeanInfo beanInfo, ManagedProperty property, AbstractBeanMetaData attachment, MetaValue value)
/*     */   {
/* 137 */     String name = property.getName();
/* 138 */     PropertyMetaData pmd = getExactPropertyMetaData(attachment, name);
/* 139 */     PropertyInfo propertyInfo = beanInfo.getProperty(name);
/* 140 */     if ((pmd instanceof AbstractPropertyMetaData))
/*     */     {
/* 142 */       AbstractPropertyMetaData apmd = (AbstractPropertyMetaData)pmd;
/* 143 */       apmd.setValue(new AbstractValueMetaData(this.metaValueFactory.unwrap(value, propertyInfo.getType())));
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, AbstractBeanMetaData attachment, MetaValue value)
/*     */   {
/* 149 */     return (beanInfo == null) || (property == null) || (value == null) ? attachment.getName() : null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.managed.BeanInstanceClassFactory
 * JD-Core Version:    0.6.0
 */