/*    */ package org.jboss.deployers.vfs.deployer.kernel;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.URI;
/*    */ import java.util.Properties;
/*    */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
/*    */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*    */ import org.jboss.kernel.plugins.deployment.props.DeploymentBuilder;
/*    */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ 
/*    */ public class Properties2BeansDeployer extends AbstractVFSParsingDeployer<KernelDeployment>
/*    */ {
/*    */   public Properties2BeansDeployer()
/*    */   {
/* 49 */     super(KernelDeployment.class);
/* 50 */     setSuffix("-beans.properties");
/*    */ 
/* 52 */     setBuildManagedObject(true);
/*    */   }
/*    */ 
/*    */   protected void init(VFSDeploymentUnit unit, KernelDeployment metaData, VirtualFile file)
/*    */     throws Exception
/*    */   {
/* 58 */     String name = file.toURI().toString();
/* 59 */     metaData.setName(name);
/*    */   }
/*    */ 
/*    */   protected KernelDeployment parse(VFSDeploymentUnit unit, VirtualFile file, KernelDeployment root) throws Exception
/*    */   {
/* 64 */     Properties properties = new Properties();
/* 65 */     InputStream is = file.openStream();
/*    */     try
/*    */     {
/* 68 */       properties.load(is);
/*    */ 
/* 70 */       DeploymentBuilder deploymentBuilder = new DeploymentBuilder(properties);
/* 71 */       KernelDeployment localKernelDeployment = deploymentBuilder.build();
/*    */       return localKernelDeployment;
/*    */     }
/*    */     finally
/*    */     {
/*    */       try
/*    */       {
/* 77 */         is.close();
/*    */       } catch (IOException ignored) {
/*    */       }
/*    */     }
/* 81 */     throw localObject;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.Properties2BeansDeployer
 * JD-Core Version:    0.6.0
 */