/*    */ package org.jboss.deployers.vfs.deployer.kernel;
/*    */ 
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ public class BeanMetaDataDeployer extends AbstractSimpleRealDeployer<BeanMetaData>
/*    */ {
/*    */   private final KernelController controller;
/*    */ 
/*    */   public BeanMetaDataDeployer(Kernel kernel)
/*    */   {
/* 55 */     super(BeanMetaData.class);
/* 56 */     if (kernel == null)
/* 57 */       throw new IllegalArgumentException("Null kernel");
/* 58 */     this.controller = kernel.getController();
/* 59 */     setComponentsOnly(true);
/* 60 */     setUseUnitName(true);
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit, BeanMetaData deployment)
/*    */     throws DeploymentException
/*    */   {
/* 66 */     KernelControllerContext context = new AbstractKernelControllerContext(null, deployment, null);
/*    */     try
/*    */     {
/* 69 */       this.controller.install(context);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 73 */       throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + deployment.getName(), t);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit, BeanMetaData deployment)
/*    */   {
/* 80 */     this.controller.uninstall(deployment.getName());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.BeanMetaDataDeployer
 * JD-Core Version:    0.6.0
 */