/*     */ package org.jboss.deployers.vfs.deployer.kernel;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.spi.NamedAliasMetaData;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
/*     */ import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ 
/*     */ public class AliasDeploymentDeployer extends AbstractComponentDeployer<KernelDeployment, NamedAliasMetaData>
/*     */ {
/*     */   public AliasDeploymentDeployer()
/*     */   {
/*  43 */     setDeploymentVisitor(new KernelDeploymentVisitor());
/*  44 */     setComponentVisitor(new AliasMetaDataVisitor());
/*     */   }
/*     */ 
/*     */   protected static void addAliasComponent(DeploymentUnit unit, NamedAliasMetaData alias)
/*     */   {
/*  49 */     DeploymentUnit component = unit.addComponent(alias.getAliasValue().toString());
/*  50 */     component.addAttachment(NamedAliasMetaData.class.getName(), alias);
/*     */   }
/*     */ 
/*     */   protected static void removeAliasComponent(DeploymentUnit unit, NamedAliasMetaData alias)
/*     */   {
/*  55 */     unit.removeComponent(alias.getAliasValue().toString());
/*     */   }
/*     */ 
/*     */   public static class AliasMetaDataVisitor
/*     */     implements DeploymentVisitor<NamedAliasMetaData>
/*     */   {
/*     */     public Class<NamedAliasMetaData> getVisitorType()
/*     */     {
/*  96 */       return NamedAliasMetaData.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, NamedAliasMetaData deployment) throws DeploymentException
/*     */     {
/* 101 */       AliasDeploymentDeployer.addAliasComponent(unit, deployment);
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, NamedAliasMetaData deployment)
/*     */     {
/* 106 */       AliasDeploymentDeployer.removeAliasComponent(unit, deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class KernelDeploymentVisitor
/*     */     implements DeploymentVisitor<KernelDeployment>
/*     */   {
/*     */     public Class<KernelDeployment> getVisitorType()
/*     */     {
/*  65 */       return KernelDeployment.class;
/*     */     }
/*     */ 
/*     */     public void deploy(DeploymentUnit unit, KernelDeployment deployment) throws DeploymentException
/*     */     {
/*  70 */       Set aliases = deployment.getAliases();
/*  71 */       if ((aliases != null) && (!aliases.isEmpty()))
/*     */       {
/*  73 */         for (NamedAliasMetaData alias : aliases)
/*  74 */           AliasDeploymentDeployer.addAliasComponent(unit, alias);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void undeploy(DeploymentUnit unit, KernelDeployment deployment)
/*     */     {
/*  80 */       Set aliases = deployment.getAliases();
/*  81 */       if ((aliases != null) && (!aliases.isEmpty()))
/*     */       {
/*  83 */         for (NamedAliasMetaData alias : aliases)
/*  84 */           AliasDeploymentDeployer.removeAliasComponent(unit, alias);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.vfs.deployer.kernel.AliasDeploymentDeployer
 * JD-Core Version:    0.6.0
 */