/*     */ package org.jboss.deployers.structure.spi.helpers;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.DeploymentState;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.spi.attachments.AttachmentsFactory;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.structure.spi.ClassLoaderFactory;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*     */ import org.jboss.deployers.structure.spi.DeploymentContextVisitor;
/*     */ import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.MutableMetaData;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ 
/*     */ public class ComponentDeploymentContext
/*     */   implements DeploymentContext
/*     */ {
/*     */   private static final long serialVersionUID = -5105972679660633071L;
/*  62 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private String name;
/*     */   private Set<Object> controllerContextNames;
/*     */   private DeploymentUnit unit;
/*     */   private DeploymentContext parent;
/*  77 */   private List<DeploymentContext> components = new CopyOnWriteArrayList();
/*     */ 
/*  80 */   private transient MutableAttachments transientAttachments = AttachmentsFactory.createMutableAttachments();
/*     */ 
/*  83 */   private transient MutableAttachments transientManagedObjects = AttachmentsFactory.createMutableAttachments();
/*     */   private ScopeKey scope;
/*     */   private ScopeKey mutableScope;
/*     */ 
/*     */   public ComponentDeploymentContext()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ComponentDeploymentContext(String name, DeploymentContext parent)
/*     */   {
/* 107 */     if (name == null)
/* 108 */       throw new IllegalArgumentException("Null name");
/* 109 */     if (parent == null)
/* 110 */       throw new IllegalArgumentException("Null parent");
/* 111 */     this.name = name;
/* 112 */     this.parent = parent;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 117 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Set<Object> getControllerContextNames()
/*     */   {
/* 122 */     return this.controllerContextNames != null ? Collections.unmodifiableSet(this.controllerContextNames) : null;
/*     */   }
/*     */ 
/*     */   public synchronized void addControllerContextName(Object name)
/*     */   {
/* 127 */     if (this.controllerContextNames == null)
/* 128 */       this.controllerContextNames = new HashSet();
/* 129 */     this.controllerContextNames.add(name);
/*     */   }
/*     */ 
/*     */   public synchronized void removeControllerContextName(Object name)
/*     */   {
/* 134 */     if (this.controllerContextNames != null)
/*     */     {
/* 136 */       this.controllerContextNames.remove(name);
/* 137 */       if (this.controllerContextNames.isEmpty())
/* 138 */         this.controllerContextNames = null;
/*     */     }
/*     */     else {
/* 141 */       this.log.warn("Removing name on null names: " + name);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getSimpleName() {
/* 146 */     return this.parent.getSimpleName();
/*     */   }
/*     */ 
/*     */   public String getRelativePath()
/*     */   {
/* 151 */     return this.parent.getRelativePath();
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/* 156 */     return 0;
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int relativeOrder)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Comparator<DeploymentContext> getComparator()
/*     */   {
/* 166 */     return null;
/*     */   }
/*     */ 
/*     */   public void setComparator(Comparator<DeploymentContext> comparator)
/*     */   {
/*     */   }
/*     */ 
/*     */   public Set<String> getTypes()
/*     */   {
/* 176 */     return this.parent.getTypes();
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/* 181 */     if (this.scope == null)
/*     */     {
/* 183 */       ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
/* 184 */       this.scope = builder.getComponentScope(this);
/*     */     }
/* 186 */     return this.scope;
/*     */   }
/*     */ 
/*     */   public void setScope(ScopeKey scope)
/*     */   {
/* 191 */     this.scope = scope;
/*     */   }
/*     */ 
/*     */   public ScopeKey getMutableScope()
/*     */   {
/* 196 */     if (this.mutableScope == null)
/*     */     {
/* 198 */       ScopeBuilder builder = AbstractDeploymentContext.getScopeBuilder(this);
/* 199 */       this.mutableScope = builder.getMutableComponentScope(this);
/*     */     }
/* 201 */     return this.mutableScope;
/*     */   }
/*     */ 
/*     */   public void setMutableScope(ScopeKey mutableScope)
/*     */   {
/* 206 */     this.mutableScope = mutableScope;
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/* 211 */     return AbstractDeploymentContext.getMetaData(this);
/*     */   }
/*     */ 
/*     */   public MutableMetaData getMutableMetaData()
/*     */   {
/* 216 */     return AbstractDeploymentContext.getMutableMetaData(this);
/*     */   }
/*     */ 
/*     */   public DeploymentState getState()
/*     */   {
/* 221 */     return this.parent.getState();
/*     */   }
/*     */ 
/*     */   public void setState(DeploymentState state)
/*     */   {
/* 226 */     this.parent.setState(state);
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit()
/*     */   {
/* 231 */     if (this.unit == null)
/* 232 */       throw new IllegalStateException("Deployment unit has not been set");
/* 233 */     return this.unit;
/*     */   }
/*     */ 
/*     */   public void setDeploymentUnit(DeploymentUnit unit)
/*     */   {
/* 238 */     this.unit = unit;
/*     */   }
/*     */ 
/*     */   public void setMetaDataPath(String path)
/*     */   {
/* 243 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */   {
/* 248 */     return this.parent.getClassLoader();
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoader classLoader)
/*     */   {
/* 253 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException
/*     */   {
/* 258 */     return false;
/*     */   }
/*     */ 
/*     */   public void removeClassLoader()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoaderFactory factory)
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean isTopLevel()
/*     */   {
/* 271 */     return false;
/*     */   }
/*     */ 
/*     */   public DeploymentContext getTopLevel()
/*     */   {
/* 276 */     return this.parent.getTopLevel();
/*     */   }
/*     */ 
/*     */   public DeploymentContext getParent()
/*     */   {
/* 281 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(DeploymentContext parent)
/*     */   {
/* 286 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public List<DeploymentContext> getChildren()
/*     */   {
/* 291 */     return Collections.emptyList();
/*     */   }
/*     */ 
/*     */   public void addChild(DeploymentContext child)
/*     */   {
/* 296 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public boolean removeChild(DeploymentContext child)
/*     */   {
/* 301 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public Deployment getDeployment()
/*     */   {
/* 306 */     return this.parent.getDeployment();
/*     */   }
/*     */ 
/*     */   public void setDeployment(Deployment deployment)
/*     */   {
/* 311 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public boolean isComponent()
/*     */   {
/* 316 */     return true;
/*     */   }
/*     */ 
/*     */   public List<DeploymentContext> getComponents()
/*     */   {
/* 321 */     return Collections.unmodifiableList(this.components);
/*     */   }
/*     */ 
/*     */   public void addComponent(DeploymentContext component)
/*     */   {
/* 326 */     if (component == null)
/* 327 */       throw new IllegalArgumentException("Null component");
/* 328 */     this.components.add(component);
/*     */   }
/*     */ 
/*     */   public boolean removeComponent(DeploymentContext component)
/*     */   {
/* 333 */     if (component == null)
/* 334 */       throw new IllegalArgumentException("Null component");
/* 335 */     boolean result = this.components.remove(component);
/* 336 */     component.cleanup();
/* 337 */     return result;
/*     */   }
/*     */ 
/*     */   public ClassLoader getResourceClassLoader()
/*     */   {
/* 342 */     return this.parent.getResourceClassLoader();
/*     */   }
/*     */ 
/*     */   public DeploymentResourceLoader getResourceLoader()
/*     */   {
/* 347 */     return this.parent.getResourceLoader();
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 352 */     return this.parent.getDependencyInfo();
/*     */   }
/*     */ 
/*     */   public void visit(DeploymentContextVisitor visitor) throws DeploymentException
/*     */   {
/* 357 */     if (visitor == null) {
/* 358 */       throw new IllegalArgumentException("Null visitor");
/*     */     }
/* 360 */     visit(this, visitor);
/*     */   }
/*     */ 
/*     */   private void visit(DeploymentContext context, DeploymentContextVisitor visitor)
/*     */     throws DeploymentException
/*     */   {
/* 372 */     visitor.visit(context);
/*     */     try
/*     */     {
/* 375 */       List children = context.getChildren();
/* 376 */       if (children.isEmpty()) {
/* 377 */         return;
/*     */       }
/* 379 */       DeploymentContext[] childContexts = (DeploymentContext[])children.toArray(new DeploymentContext[children.size()]);
/* 380 */       for (int i = 0; i < childContexts.length; i++)
/*     */       {
/* 382 */         if (childContexts[i] == null)
/* 383 */           throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
/*     */         try
/*     */         {
/* 386 */           visit(childContexts[i], visitor);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 390 */           for (int j = i - 1; j >= 0; j--)
/* 391 */             visitError(childContexts[j], visitor, true);
/* 392 */           throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + childContexts[i].getName(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 398 */       visitError(context, visitor, false);
/* 399 */       throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren)
/*     */     throws DeploymentException
/*     */   {
/* 413 */     if (visitChildren)
/*     */     {
/* 415 */       List children = context.getChildren();
/* 416 */       if (children.isEmpty()) {
/* 417 */         return;
/*     */       }
/* 419 */       for (DeploymentContext child : children)
/*     */       {
/*     */         try
/*     */         {
/* 423 */           visitError(child, visitor, true);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 427 */           this.log.warn("Error during visit error: " + child.getName(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 434 */       visitor.error(context);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 438 */       this.log.warn("Error during visit error: " + context.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Attachments getPredeterminedManagedObjects()
/*     */   {
/* 444 */     return this.parent.getPredeterminedManagedObjects();
/*     */   }
/*     */ 
/*     */   public void setPredeterminedManagedObjects(Attachments objects)
/*     */   {
/* 449 */     throw new UnsupportedOperationException("Not supported for components");
/*     */   }
/*     */ 
/*     */   public MutableAttachments getTransientManagedObjects()
/*     */   {
/* 454 */     return this.transientManagedObjects;
/*     */   }
/*     */ 
/*     */   public MutableAttachments getTransientAttachments()
/*     */   {
/* 459 */     return this.transientAttachments;
/*     */   }
/*     */ 
/*     */   public Throwable getProblem()
/*     */   {
/* 464 */     return this.parent.getProblem();
/*     */   }
/*     */ 
/*     */   public void setProblem(Throwable problem)
/*     */   {
/* 469 */     this.parent.setProblem(problem);
/*     */   }
/*     */ 
/*     */   public void deployed()
/*     */   {
/* 474 */     this.parent.deployed();
/*     */   }
/*     */ 
/*     */   public boolean isDeployed()
/*     */   {
/* 479 */     return this.parent.isDeployed();
/*     */   }
/*     */ 
/*     */   public void cleanup()
/*     */   {
/* 484 */     AbstractDeploymentContext.cleanupRepository(this);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 489 */     StringBuilder buffer = new StringBuilder();
/* 490 */     buffer.append(getClass().getSimpleName());
/* 491 */     buffer.append('@');
/* 492 */     buffer.append(System.identityHashCode(this));
/* 493 */     buffer.append('{').append(this.name).append('}');
/* 494 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.helpers.ComponentDeploymentContext
 * JD-Core Version:    0.6.0
 */