/*    */ package org.jboss.deployers.structure.spi.helpers;
/*    */ 
/*    */ import org.jboss.deployers.client.spi.Deployment;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.Attachments;
/*    */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*    */ import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
/*    */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*    */ import org.jboss.deployers.structure.spi.StructuralDeployers;
/*    */ import org.jboss.deployers.structure.spi.StructureBuilder;
/*    */ 
/*    */ public class AbstractStructuralDeployers
/*    */   implements StructuralDeployers
/*    */ {
/*    */   private StructureBuilder structureBuilder;
/*    */ 
/*    */   public StructureBuilder getStructureBuilder()
/*    */   {
/* 51 */     return this.structureBuilder;
/*    */   }
/*    */ 
/*    */   public void setStructureBuilder(StructureBuilder structureBuilder)
/*    */   {
/* 61 */     this.structureBuilder = structureBuilder;
/*    */   }
/*    */ 
/*    */   public DeploymentContext determineStructure(Deployment deployment) throws DeploymentException
/*    */   {
/* 66 */     StructureBuilder builder = getStructureBuilder();
/* 67 */     if (builder == null) {
/* 68 */       throw new IllegalStateException("No structure builder has been configured");
/*    */     }
/* 70 */     Attachments attachments = deployment.getPredeterminedManagedObjects();
/* 71 */     StructureMetaData structureMetaData = (StructureMetaData)attachments.getAttachment(StructureMetaData.class);
/* 72 */     if (structureMetaData == null)
/*    */     {
/* 74 */       structureMetaData = StructureMetaDataFactory.createStructureMetaData();
/*    */       try
/*    */       {
/* 77 */         determineStructure(deployment, structureMetaData);
/*    */       }
/*    */       catch (DeploymentException e)
/*    */       {
/* 81 */         throw e;
/*    */       }
/*    */       catch (Throwable t)
/*    */       {
/* 85 */         throw DeploymentException.rethrowAsDeploymentException("Exception determining structure: " + deployment, t);
/*    */       }
/*    */     }
/*    */ 
/* 89 */     return this.structureBuilder.populateContext(deployment, structureMetaData);
/*    */   }
/*    */ 
/*    */   protected void determineStructure(Deployment deployment, StructureMetaData structure)
/*    */     throws Exception
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.helpers.AbstractStructuralDeployers
 * JD-Core Version:    0.6.0
 */