/*     */ package org.jboss.deployers.structure.spi.classloading.helpers;
/*     */ 
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.ModuleCapability;
/*     */ import org.jboss.deployers.structure.spi.classloading.RequireModule;
/*     */ import org.jboss.deployers.structure.spi.classloading.Requirement;
/*     */ import org.jboss.deployers.structure.spi.classloading.Version;
/*     */ import org.jboss.deployers.structure.spi.classloading.VersionRange;
/*     */ 
/*     */ public class ModuleCapabilityImpl
/*     */   implements ModuleCapability
/*     */ {
/*     */   private static final long serialVersionUID = -5444212755644141118L;
/*     */   private String name;
/*     */   private Version version;
/*     */ 
/*     */   public ModuleCapabilityImpl(String name)
/*     */   {
/*  55 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public ModuleCapabilityImpl(String name, Version version)
/*     */   {
/*  67 */     if (name == null)
/*  68 */       throw new IllegalArgumentException("Null name");
/*  69 */     if (version == null)
/*  70 */       version = Version.DEFAULT_VERSION;
/*  71 */     this.name = name;
/*  72 */     this.version = version;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  78 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Version getVersion()
/*     */   {
/*  83 */     return this.version;
/*     */   }
/*     */ 
/*     */   public boolean resolves(DeploymentUnit unit, Requirement requirement)
/*     */   {
/*  88 */     if (!(requirement instanceof RequireModule))
/*  89 */       return false;
/*  90 */     RequireModule requireModule = (RequireModule)requirement;
/*  91 */     if (!getName().equals(requireModule.getName()))
/*  92 */       return false;
/*  93 */     return requireModule.getVersionRange().isInRange(getVersion());
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  99 */     if (obj == this)
/* 100 */       return true;
/* 101 */     if ((obj == null) || (!(obj instanceof ModuleCapability)))
/* 102 */       return false;
/* 103 */     ModuleCapability other = (ModuleCapability)obj;
/* 104 */     if (!getName().equals(other.getName()))
/* 105 */       return false;
/* 106 */     return getVersion().equals(other.getVersion());
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 112 */     return getName().hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 118 */     return "Module: " + getName() + ":" + getVersion();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.classloading.helpers.ModuleCapabilityImpl
 * JD-Core Version:    0.6.0
 */