package org.jboss.deployers.structure.spi;

import java.util.List;
import java.util.Set;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;

public abstract interface DeploymentUnit extends MutableAttachments
{
  public abstract String getName();

  public abstract Set<Object> getControllerContextNames();

  public abstract void addControllerContextName(Object paramObject);

  public abstract void removeControllerContextName(Object paramObject);

  public abstract String getSimpleName();

  public abstract String getRelativePath();

  public abstract Set<String> getTypes();

  public abstract ScopeKey getScope();

  public abstract void setScope(ScopeKey paramScopeKey);

  public abstract ScopeKey getMutableScope();

  public abstract void setMutableScope(ScopeKey paramScopeKey);

  public abstract MetaData getMetaData();

  public abstract MutableMetaData getMutableMetaData();

  public abstract ClassLoader getClassLoader();

  public abstract boolean createClassLoader(ClassLoaderFactory paramClassLoaderFactory)
    throws DeploymentException;

  public abstract void removeClassLoader(ClassLoaderFactory paramClassLoaderFactory);

  public abstract <T> Set<? extends T> getAllMetaData(Class<T> paramClass);

  public abstract MutableAttachments getTransientManagedObjects();

  public abstract DeploymentUnit getTopLevel();

  public abstract DeploymentUnit getParent();

  public abstract List<DeploymentUnit> getChildren();

  public abstract List<DeploymentUnit> getComponents();

  public abstract boolean isComponent();

  public abstract DeploymentUnit addComponent(String paramString);

  public abstract boolean removeComponent(String paramString);

  public abstract DeploymentResourceLoader getResourceLoader();

  public abstract ClassLoader getResourceClassLoader();

  public abstract DependencyInfo getDependencyInfo();

  public abstract void addIDependOn(DependencyItem paramDependencyItem);

  public abstract void removeIDependOn(DependencyItem paramDependencyItem);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.DeploymentUnit
 * JD-Core Version:    0.6.0
 */