package org.jboss.deployers.structure.spi;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.ManagedObjectsWithTransientAttachments;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;

public abstract interface DeploymentContext extends ManagedObjectsWithTransientAttachments
{
  public abstract String getName();

  public abstract Set<Object> getControllerContextNames();

  public abstract void addControllerContextName(Object paramObject);

  public abstract void removeControllerContextName(Object paramObject);

  public abstract String getSimpleName();

  public abstract String getRelativePath();

  public abstract int getRelativeOrder();

  public abstract void setRelativeOrder(int paramInt);

  public abstract Comparator<DeploymentContext> getComparator();

  public abstract void setComparator(Comparator<DeploymentContext> paramComparator);

  public abstract Set<String> getTypes();

  public abstract ScopeKey getScope();

  public abstract void setScope(ScopeKey paramScopeKey);

  public abstract ScopeKey getMutableScope();

  public abstract void setMutableScope(ScopeKey paramScopeKey);

  public abstract MetaData getMetaData();

  public abstract MutableMetaData getMutableMetaData();

  public abstract DeploymentState getState();

  public abstract void setState(DeploymentState paramDeploymentState);

  public abstract Deployment getDeployment();

  public abstract void setDeployment(Deployment paramDeployment);

  public abstract DeploymentUnit getDeploymentUnit();

  public abstract void setDeploymentUnit(DeploymentUnit paramDeploymentUnit);

  public abstract ClassLoader getClassLoader();

  public abstract void setClassLoader(ClassLoader paramClassLoader);

  public abstract boolean createClassLoader(ClassLoaderFactory paramClassLoaderFactory)
    throws DeploymentException;

  public abstract void removeClassLoader();

  public abstract void removeClassLoader(ClassLoaderFactory paramClassLoaderFactory);

  public abstract boolean isTopLevel();

  public abstract DeploymentContext getTopLevel();

  public abstract DeploymentContext getParent();

  public abstract void setParent(DeploymentContext paramDeploymentContext);

  public abstract List<DeploymentContext> getChildren();

  public abstract void addChild(DeploymentContext paramDeploymentContext);

  public abstract boolean removeChild(DeploymentContext paramDeploymentContext);

  public abstract boolean isComponent();

  public abstract List<DeploymentContext> getComponents();

  public abstract void addComponent(DeploymentContext paramDeploymentContext);

  public abstract boolean removeComponent(DeploymentContext paramDeploymentContext);

  public abstract DeploymentResourceLoader getResourceLoader();

  public abstract ClassLoader getResourceClassLoader();

  public abstract DependencyInfo getDependencyInfo();

  public abstract void visit(DeploymentContextVisitor paramDeploymentContextVisitor)
    throws DeploymentException;

  public abstract boolean isDeployed();

  public abstract void deployed();

  public abstract Throwable getProblem();

  public abstract void setProblem(Throwable paramThrowable);

  public abstract void cleanup();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.structure.spi.DeploymentContext
 * JD-Core Version:    0.6.0
 */