/*     */ package org.jboss.deployers.spi.deployer.helpers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractRealDeployerWithInput<T> extends AbstractRealDeployer
/*     */ {
/*     */   private DeploymentVisitor<T> visitor;
/*     */   private boolean warned;
/*     */ 
/*     */   public AbstractRealDeployerWithInput()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractRealDeployerWithInput(Class<T> input)
/*     */   {
/*  60 */     setInput(input);
/*     */   }
/*     */ 
/*     */   public Class<? extends T> getInput()
/*     */   {
/*  66 */     Class input = super.getInput();
/*  67 */     if (input == null)
/*  68 */       throw new IllegalStateException("No input for " + this);
/*  69 */     return input;
/*     */   }
/*     */ 
/*     */   protected void setDeploymentVisitor(DeploymentVisitor<T> visitor)
/*     */   {
/*  80 */     if (visitor == null)
/*  81 */       throw new IllegalArgumentException("Null visitor");
/*  82 */     this.visitor = visitor;
/*  83 */     Class input = visitor.getVisitorType();
/*  84 */     if (input == null)
/*  85 */       throw new IllegalArgumentException("Null visitor type");
/*  86 */     setInput(input);
/*     */   }
/*     */ 
/*     */   public void internalDeploy(DeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*  92 */     if (this.visitor == null)
/*     */     {
/*  94 */       if (!this.warned)
/*     */       {
/*  96 */         this.log.error("INTERNAL ERROR: Visitor is null for " + getClass().getName());
/*  97 */         this.warned = true;
/*     */       }
/*  99 */       return;
/*     */     }
/*     */ 
/* 102 */     List visited = new ArrayList();
/*     */     try
/*     */     {
/* 105 */       Set deployments = unit.getAllMetaData(getInput());
/* 106 */       for (i$ = deployments.iterator(); i$.hasNext(); ) { Object deployment = i$.next();
/*     */ 
/* 108 */         this.visitor.deploy(unit, deployment);
/* 109 */         visited.add(deployment);
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */       Iterator i$;
/* 114 */       for (int i = visited.size() - 1; i >= 0; i--)
/*     */       {
/*     */         try
/*     */         {
/* 118 */           this.visitor.undeploy(unit, visited.get(i));
/*     */         }
/*     */         catch (Throwable ignored)
/*     */         {
/* 122 */           this.log.warn("Error during undeploy: " + unit.getName(), ignored);
/*     */         }
/*     */       }
/* 125 */       throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + unit.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void internalUndeploy(DeploymentUnit unit)
/*     */   {
/* 131 */     if (this.visitor == null)
/* 132 */       return;
/* 133 */     Set deployments = unit.getAllMetaData(getInput());
/* 134 */     for (Iterator i$ = deployments.iterator(); i$.hasNext(); ) { Object deployment = i$.next();
/* 135 */       this.visitor.undeploy(unit, deployment);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput
 * JD-Core Version:    0.6.0
 */