/*    */ package org.jboss.deployers.spi.deployer.helpers;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.deployer.DeploymentStages;
/*    */ import org.jboss.deployers.structure.spi.ClassLoaderFactory;
/*    */ import org.jboss.deployers.structure.spi.DeploymentContext;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ 
/*    */ public abstract class AbstractClassLoaderDeployer extends AbstractDeployer
/*    */   implements ClassLoaderFactory
/*    */ {
/*    */   public AbstractClassLoaderDeployer()
/*    */   {
/* 43 */     setStage(DeploymentStages.CLASSLOADER);
/* 44 */     setInput(ClassLoaderFactory.class);
/* 45 */     setAllInputs(true);
/*    */   }
/*    */ 
/*    */   public void deploy(DeploymentUnit unit) throws DeploymentException
/*    */   {
/* 50 */     ClassLoaderFactory factory = (ClassLoaderFactory)unit.getAttachment(ClassLoaderFactory.class);
/* 51 */     if (factory == null)
/* 52 */       factory = this;
/* 53 */     unit.createClassLoader(factory);
/*    */   }
/*    */ 
/*    */   public void undeploy(DeploymentUnit unit)
/*    */   {
/* 58 */     ClassLoaderFactory factory = (ClassLoaderFactory)unit.getAttachment(ClassLoaderFactory.class);
/* 59 */     if (factory == null)
/* 60 */       factory = this;
/* 61 */     unit.removeClassLoader(factory);
/*    */   }
/*    */ 
/*    */   public void removeClassLoader(DeploymentContext context)
/*    */     throws Exception
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.spi.deployer.helpers.AbstractClassLoaderDeployer
 * JD-Core Version:    0.6.0
 */