/*     */ package org.jboss.deployers.plugins.structure;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.List;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ 
/*     */ public class StructureMetaDataImpl
/*     */   implements StructureMetaData, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 2341637762171510800L;
/*  46 */   private List<ContextInfo> contexts = new CopyOnWriteArrayList();
/*     */ 
/*     */   public void addContext(ContextInfo context)
/*     */   {
/*  50 */     if (context == null)
/*  51 */       throw new IllegalArgumentException("Null context");
/*  52 */     String path = context.getPath();
/*  53 */     if (path == null) {
/*  54 */       throw new IllegalArgumentException("Context has no path");
/*     */     }
/*  56 */     for (ContextInfo other : this.contexts)
/*     */     {
/*  58 */       if (path.equals(other.getPath()))
/*  59 */         throw new IllegalStateException("Context already exists with path '" + path + "' contexts=" + getContexts());
/*     */     }
/*  61 */     this.contexts.add(context);
/*     */   }
/*     */ 
/*     */   public ContextInfo getContext(String path)
/*     */   {
/*  66 */     if (path == null)
/*  67 */       throw new IllegalArgumentException("Null path");
/*  68 */     for (ContextInfo context : this.contexts)
/*     */     {
/*  70 */       if (path.equals(context.getPath()))
/*  71 */         return context;
/*     */     }
/*  73 */     return null;
/*     */   }
/*     */ 
/*     */   public void removeContext(ContextInfo context)
/*     */   {
/*  78 */     if (context == null)
/*  79 */       throw new IllegalArgumentException("Null context");
/*  80 */     this.contexts.remove(context);
/*     */   }
/*     */ 
/*     */   public void removeContext(String path)
/*     */   {
/*  85 */     if (path == null) {
/*  86 */       throw new IllegalArgumentException("Null path");
/*     */     }
/*  88 */     for (ContextInfo context : this.contexts)
/*     */     {
/*  90 */       if (path.equals(context.getPath()))
/*  91 */         this.contexts.remove(context);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List<ContextInfo> getContexts()
/*     */   {
/*  97 */     return this.contexts;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 103 */     StringBuilder builder = new StringBuilder();
/* 104 */     builder.append(getClass().getSimpleName());
/* 105 */     builder.append("{");
/* 106 */     toString(builder);
/* 107 */     builder.append("}");
/* 108 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toString(StringBuilder builder)
/*     */   {
/* 118 */     builder.append("contexts=").append(this.contexts);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 124 */     if (obj == this)
/* 125 */       return true;
/* 126 */     if ((obj == null) || (!(obj instanceof Externalizable))) {
/* 127 */       return false;
/*     */     }
/* 129 */     StructureMetaData other = (Externalizable)obj;
/*     */ 
/* 131 */     List thisContexts = getContexts();
/* 132 */     List otherContexts = other.getContexts();
/* 133 */     if (thisContexts == null)
/* 134 */       return otherContexts == null;
/* 135 */     return thisContexts.equals(otherContexts);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 141 */     List contexts = getContexts();
/* 142 */     if (contexts == null)
/* 143 */       return 0;
/* 144 */     return contexts.hashCode();
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 150 */     this.contexts = ((List)in.readObject());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 160 */     out.writeObject(getContexts());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.structure.StructureMetaDataImpl
 * JD-Core Version:    0.6.0
 */