/*     */ package org.jboss.deployers.plugins.structure;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ 
/*     */ public class ClassPathEntryImpl
/*     */   implements ClassPathEntry, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -6463413458528845538L;
/*  45 */   static final List<ClassPathEntry> DEFAULT = Collections.singletonList(new ClassPathEntryImpl());
/*     */   private String path;
/*     */   private String suffixes;
/*     */ 
/*     */   public ClassPathEntryImpl()
/*     */   {
/*  58 */     setPath("");
/*     */   }
/*     */ 
/*     */   public ClassPathEntryImpl(String path)
/*     */   {
/*  69 */     setPath(path);
/*     */   }
/*     */ 
/*     */   public ClassPathEntryImpl(String path, String suffixes)
/*     */   {
/*  81 */     setPath(path);
/*  82 */     setSuffixes(suffixes);
/*     */   }
/*     */ 
/*     */   public String getPath()
/*     */   {
/*  87 */     return this.path;
/*     */   }
/*     */ 
/*     */   public void setPath(String path)
/*     */   {
/*  98 */     if (path == null)
/*  99 */       throw new IllegalArgumentException("Null path");
/* 100 */     this.path = path;
/*     */   }
/*     */ 
/*     */   public String getSuffixes()
/*     */   {
/* 105 */     return this.suffixes;
/*     */   }
/*     */ 
/*     */   public void setSuffixes(String suffixes)
/*     */   {
/* 115 */     this.suffixes = suffixes;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 121 */     StringBuilder builder = new StringBuilder();
/* 122 */     builder.append(getClass().getSimpleName());
/* 123 */     builder.append("{");
/* 124 */     toString(builder);
/* 125 */     builder.append("}");
/* 126 */     return builder.toString();
/*     */   }
/*     */ 
/*     */   protected void toString(StringBuilder builder)
/*     */   {
/* 136 */     builder.append("path=").append(getPath());
/* 137 */     String suffixes = getSuffixes();
/* 138 */     if (suffixes != null)
/* 139 */       builder.append(" suffixes=").append(suffixes);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 145 */     if (obj == this)
/* 146 */       return true;
/* 147 */     if ((obj == null) || (!(obj instanceof Externalizable))) {
/* 148 */       return false;
/*     */     }
/* 150 */     ClassPathEntry other = (Externalizable)obj;
/* 151 */     if (!getPath().equals(other.getPath())) {
/* 152 */       return false;
/*     */     }
/* 154 */     String thisSuffixes = getSuffixes();
/* 155 */     String otherSuffixes = other.getSuffixes();
/* 156 */     if (thisSuffixes == null)
/* 157 */       return otherSuffixes == null;
/* 158 */     return thisSuffixes.equals(otherSuffixes);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 164 */     return getPath().hashCode();
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 169 */     setPath(in.readUTF());
/* 170 */     boolean hasSuffixes = in.readBoolean();
/* 171 */     if (hasSuffixes)
/* 172 */       setSuffixes(in.readUTF());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 183 */     out.writeUTF(getPath());
/* 184 */     String suffixes = getSuffixes();
/* 185 */     out.writeBoolean(suffixes != null);
/* 186 */     if (suffixes != null)
/* 187 */       out.writeUTF(suffixes);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.structure.ClassPathEntryImpl
 * JD-Core Version:    0.6.0
 */