/*    */ package org.jboss.deployers.plugins.sort;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.deployers.spi.deployer.Deployer;
/*    */ 
/*    */ public class DeployerDomino
/*    */   implements Domino<Set<String>>
/*    */ {
/*    */   private Deployer deployer;
/*    */   private Dots<Set<String>> head;
/*    */   private Dots<Set<String>> tail;
/*    */ 
/*    */   public DeployerDomino(Deployer deployer)
/*    */   {
/* 41 */     if (deployer == null)
/* 42 */       throw new IllegalArgumentException("Null deployer!");
/* 43 */     this.deployer = deployer;
/* 44 */     this.head = new SetDots(deployer.getInputs());
/* 45 */     this.tail = new SetDots(deployer.getOutputs());
/*    */   }
/*    */ 
/*    */   public Deployer getDeployer()
/*    */   {
/* 50 */     return this.deployer;
/*    */   }
/*    */ 
/*    */   public Dots<Set<String>> getHead()
/*    */   {
/* 55 */     return this.head;
/*    */   }
/*    */ 
/*    */   public Dots<Set<String>> getTail()
/*    */   {
/* 60 */     return this.tail;
/*    */   }
/*    */ 
/*    */   public int getRelativeOrder()
/*    */   {
/* 65 */     return this.deployer.getRelativeOrder();
/*    */   }
/*    */ 
/*    */   public void setRelativeOrder(int order)
/*    */   {
/* 70 */     this.deployer.setRelativeOrder(order);
/*    */   }
/*    */ 
/*    */   public String getInfo()
/*    */   {
/* 75 */     StringBuilder builder = new StringBuilder();
/* 76 */     builder.append(this.deployer);
/* 77 */     builder.append("{inputs=").append(this.deployer.getInputs());
/* 78 */     builder.append(" outputs=").append(this.deployer.getOutputs());
/* 79 */     builder.append("}\n");
/* 80 */     return builder.toString();
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 86 */     return this.deployer + ", " + this.head + "|" + this.tail;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.sort.DeployerDomino
 * JD-Core Version:    0.6.0
 */