/*     */ package org.jboss.deployers.plugins.scanner;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.Executors;
/*     */ import java.util.concurrent.ScheduledExecutorService;
/*     */ import java.util.concurrent.ScheduledFuture;
/*     */ import java.util.concurrent.ThreadFactory;
/*     */ import java.util.concurrent.TimeUnit;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ 
/*     */ public class VFSDeploymentScannerImpl
/*     */   implements Runnable
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(VFSDeploymentScannerImpl.class);
/*     */   private MainDeployer mainDeployer;
/*  66 */   private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
/*     */   private VirtualFileFilter filter;
/*     */   private ScheduledExecutorService scanExecutor;
/*     */   private ScheduledFuture activeScan;
/*     */   private URI serverHomeURI;
/*  78 */   private List<URI> uriList = Collections.synchronizedList(new ArrayList());
/*     */ 
/*  81 */   private List<VirtualFile> vdfList = Collections.synchronizedList(new ArrayList());
/*     */ 
/*  84 */   private boolean doRecursiveSearch = true;
/*     */ 
/*  86 */   private long scanPeriod = 5000L;
/*     */   private int scanCount;
/*  90 */   private Map<VirtualFile, DeploymentInfo> deployedMap = new ConcurrentHashMap();
/*     */ 
/*     */   public void setMainDeployer(MainDeployer deployer)
/*     */   {
/* 103 */     this.mainDeployer = deployer;
/*     */   }
/*     */ 
/*     */   public VirtualFileFilter getFilterInstance()
/*     */   {
/* 108 */     return this.filter;
/*     */   }
/*     */ 
/*     */   public void setFilterInstance(VirtualFileFilter filter) {
/* 112 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public ScheduledExecutorService getScanExecutor()
/*     */   {
/* 120 */     return this.scanExecutor;
/*     */   }
/*     */ 
/*     */   public void setScanExecutor(ScheduledExecutorService scanExecutor)
/*     */   {
/* 128 */     this.scanExecutor = scanExecutor;
/*     */   }
/*     */ 
/*     */   public long getScanPeriod()
/*     */   {
/* 136 */     return this.scanPeriod;
/*     */   }
/*     */ 
/*     */   public void setScanPeriod(long period)
/*     */   {
/* 143 */     this.scanPeriod = period;
/*     */   }
/*     */ 
/*     */   public boolean isScanEnabled()
/*     */   {
/* 153 */     return this.activeScan != null;
/*     */   }
/*     */ 
/*     */   public synchronized int getScanCount()
/*     */   {
/* 158 */     return this.scanCount;
/*     */   }
/*     */ 
/*     */   public synchronized void resetScanCount() {
/* 162 */     this.scanCount = 0;
/*     */   }
/*     */ 
/*     */   public synchronized void setScanEnabled(boolean scanEnabled)
/*     */   {
/* 171 */     if ((scanEnabled == true) && (this.activeScan == null))
/*     */     {
/* 173 */       this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
/*     */     }
/* 176 */     else if ((!scanEnabled) && (this.activeScan != null))
/*     */     {
/* 178 */       this.activeScan.cancel(true);
/* 179 */       this.activeScan = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setURIs(String listspec)
/*     */     throws URISyntaxException, IOException
/*     */   {
/* 192 */     if (listspec == null)
/*     */     {
/* 194 */       this.uriList.clear();
/* 195 */       return;
/*     */     }
/* 197 */     List list = new LinkedList();
/*     */ 
/* 199 */     StringTokenizer stok = new StringTokenizer(listspec, ",");
/* 200 */     while (stok.hasMoreTokens())
/*     */     {
/* 202 */       String urispec = stok.nextToken().trim();
/*     */ 
/* 204 */       log.debug("Adding URI from spec: " + urispec);
/*     */ 
/* 206 */       URI uri = makeURI(urispec);
/*     */ 
/* 208 */       log.debug("URI: " + uri);
/*     */ 
/* 210 */       list.add(uri);
/*     */     }
/* 212 */     setURIList(list);
/*     */   }
/*     */ 
/*     */   public void setURIList(List<URI> list)
/*     */     throws IOException
/*     */   {
/* 223 */     if (list == null)
/*     */     {
/* 225 */       return;
/*     */     }
/*     */ 
/* 229 */     this.uriList.clear();
/*     */ 
/* 231 */     for (int n = 0; n < list.size(); n++)
/*     */     {
/* 233 */       URI uri = (URI)list.get(n);
/* 234 */       if (uri == null)
/*     */       {
/* 236 */         throw new IllegalArgumentException("list element[" + n + "] is null");
/*     */       }
/* 238 */       addURI(uri);
/*     */     }
/* 240 */     log.debug("URI list: " + this.uriList);
/*     */   }
/*     */ 
/*     */   public List<URI> getURIList()
/*     */   {
/* 245 */     return new ArrayList(this.uriList);
/*     */   }
/*     */ 
/*     */   public void setRecursiveSearch(boolean recurse)
/*     */   {
/* 250 */     this.doRecursiveSearch = recurse;
/*     */   }
/*     */ 
/*     */   public boolean getRecursiveSearch()
/*     */   {
/* 255 */     return this.doRecursiveSearch;
/*     */   }
/*     */ 
/*     */   public void addURI(URI uri)
/*     */     throws IOException
/*     */   {
/* 262 */     if (uri == null)
/*     */     {
/* 264 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 266 */     if (this.uriList.add(uri) == true)
/*     */     {
/* 268 */       log.debug("Added URI: " + uri);
/* 269 */       VirtualFile vf = VFS.getRoot(uri);
/* 270 */       this.vdfList.add(vf);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeURI(URI uri)
/*     */     throws IOException
/*     */   {
/* 277 */     if (uri == null)
/*     */     {
/* 279 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 281 */     VirtualFile vf = VFS.getRoot(uri);
/* 282 */     this.vdfList.remove(vf);
/* 283 */     boolean success = this.uriList.remove(uri);
/*     */ 
/* 285 */     if (success)
/*     */     {
/* 287 */       log.debug("Removed URI: " + uri);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasURI(URI uri)
/*     */   {
/* 293 */     if (uri == null)
/*     */     {
/* 295 */       throw new NullPointerException("uri argument cannot be null");
/*     */     }
/* 297 */     return this.uriList.contains(uri);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 304 */     this.vdfList.clear();
/* 305 */     for (URI uri : this.uriList)
/*     */     {
/* 307 */       VirtualFile vf = VFS.getRoot(uri);
/* 308 */       this.vdfList.add(vf);
/*     */     }
/*     */ 
/* 312 */     if (this.scanExecutor == null)
/*     */     {
/* 314 */       this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory()
/*     */       {
/*     */         public Thread newThread(Runnable r)
/*     */         {
/* 319 */           return new Thread(r, "VFSDeploymentScanner");
/*     */         }
/*     */       });
/*     */     }
/* 324 */     this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/* 336 */       scan();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 340 */       log.warn("Scan failed", e);
/*     */     }
/*     */     finally
/*     */     {
/* 344 */       incScanCount();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 350 */     if (this.activeScan != null)
/*     */     {
/* 352 */       this.activeScan.cancel(true);
/* 353 */       this.activeScan = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void scan() throws Exception
/*     */   {
/* 359 */     if (this.vdfList == null)
/*     */     {
/* 361 */       throw new IllegalStateException("not initialized");
/*     */     }
/* 363 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 366 */     log.debug("Begin deployment scan");
/*     */ 
/* 369 */     List toDeployList = new LinkedList();
/* 370 */     synchronized (this.vdfList)
/*     */     {
/* 372 */       for (VirtualFile vf : this.vdfList)
/*     */       {
/* 374 */         if (trace)
/* 375 */           log.trace("Checking file: " + vf);
/* 376 */         if (vf.isLeaf())
/*     */         {
/* 379 */           toDeployList.add(vf);
/*     */         }
/*     */         else
/*     */         {
/* 384 */           addDeployments(toDeployList, vf);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 389 */     if (trace)
/*     */     {
/* 391 */       log.trace("toDeployList: " + toDeployList);
/*     */     }
/* 393 */     LinkedList toRemoveList = new LinkedList();
/* 394 */     LinkedList toCheckForUpdateList = new LinkedList();
/*     */ 
/* 396 */     synchronized (this.deployedMap)
/*     */     {
/* 399 */       Iterator iter = this.deployedMap.keySet().iterator();
/* 400 */       while (iter.hasNext())
/*     */       {
/* 402 */         VirtualFile vf = (VirtualFile)iter.next();
/* 403 */         if (toDeployList.contains(vf))
/*     */         {
/* 405 */           toCheckForUpdateList.add(vf);
/*     */         }
/*     */         else
/*     */         {
/* 409 */           toRemoveList.add(vf);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 418 */     for (VirtualFile vf : toRemoveList)
/*     */     {
/* 420 */       undeploy(vf);
/*     */     }
/*     */ 
/* 428 */     ArrayList toUpdateList = new ArrayList(toCheckForUpdateList.size());
/* 429 */     for (VirtualFile vf : toUpdateList)
/*     */     {
/* 431 */       DeploymentInfo info = (DeploymentInfo)this.deployedMap.get(vf);
/* 432 */       long modified = vf.getLastModified();
/* 433 */       Long prevLastDeployed = Long.valueOf(info.lastModified);
/* 434 */       if (prevLastDeployed.compareTo(Long.valueOf(modified)) < 0)
/*     */       {
/* 436 */         info.lastModified = modified;
/* 437 */         if (trace)
/*     */         {
/* 439 */           log.trace("Re-deploying " + vf);
/*     */         }
/* 441 */         toUpdateList.add(vf);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 449 */     for (int i = toUpdateList.size() - 1; i >= 0; i--)
/*     */     {
/* 451 */       VirtualFile vf = (VirtualFile)toUpdateList.get(i);
/* 452 */       undeploy(vf);
/*     */     }
/*     */ 
/* 456 */     for (int i = 0; i < toUpdateList.size(); i++)
/*     */     {
/* 458 */       VirtualFile vf = (VirtualFile)toUpdateList.get(i);
/* 459 */       deploy(vf);
/*     */     }
/*     */ 
/* 467 */     for (Iterator i = toDeployList.iterator(); i.hasNext(); )
/*     */     {
/* 469 */       VirtualFile vf = (VirtualFile)i.next();
/*     */ 
/* 472 */       if (!this.deployedMap.containsKey(vf))
/*     */       {
/* 474 */         deploy(vf);
/*     */       }
/*     */ 
/* 478 */       i.remove();
/*     */     }
/*     */ 
/* 481 */     log.debug("End deployment scan");
/*     */   }
/*     */ 
/*     */   protected synchronized void incScanCount()
/*     */   {
/* 490 */     this.scanCount += 1;
/* 491 */     notifyAll();
/*     */   }
/*     */ 
/*     */   private URI makeURI(String urispec)
/*     */     throws URISyntaxException
/*     */   {
/* 502 */     urispec = StringPropertyReplacer.replaceProperties(urispec);
/* 503 */     return this.serverHomeURI.resolve(urispec);
/*     */   }
/*     */ 
/*     */   private void addDeployments(List<VirtualFile> list, VirtualFile root)
/*     */     throws IOException
/*     */   {
/* 515 */     List components = root.getChildren();
/*     */ 
/* 517 */     for (VirtualFile vf : components)
/*     */     {
/* 519 */       if (vf.isLeaf())
/*     */       {
/* 522 */         if ((this.filter == null) || (this.filter.accepts(vf)))
/*     */         {
/* 524 */           list.add(vf);
/*     */         }
/*     */ 
/*     */       }
/* 529 */       else if ((vf.getName().indexOf('.') == -1) && (this.doRecursiveSearch))
/*     */       {
/* 532 */         addDeployments(list, vf);
/*     */       }
/*     */       else
/*     */       {
/* 536 */         list.add(vf);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void deploy(VirtualFile vf)
/*     */   {
/* 548 */     log.debug("Deploying: " + vf);
/* 549 */     Deployment deployment = this.deploymentFactory.createVFSDeployment(vf);
/*     */     try
/*     */     {
/* 552 */       this.mainDeployer.addDeployment(deployment);
/* 553 */       this.mainDeployer.process();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 557 */       log.warn("Failed to deploy: " + vf, e);
/*     */ 
/* 559 */       return;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 568 */       DeploymentInfo info = new DeploymentInfo(deployment, vf.getLastModified());
/* 569 */       if (!this.deployedMap.containsKey(vf))
/*     */       {
/* 571 */         this.deployedMap.put(vf, info);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 576 */       log.warn("Failed to obtain lastModified for: " + vf, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void undeploy(VirtualFile vf)
/*     */   {
/*     */     try
/*     */     {
/* 587 */       log.debug("Undeploying: " + vf);
/* 588 */       DeploymentInfo info = (DeploymentInfo)this.deployedMap.remove(vf);
/* 589 */       this.mainDeployer.removeDeployment(info.deployment);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 593 */       log.error("Failed to undeploy: " + vf, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private class DeploymentInfo
/*     */   {
/*     */     Deployment deployment;
/*     */     long lastModified;
/*     */ 
/*     */     public DeploymentInfo(Deployment deployment, long lastModified)
/*     */     {
/* 616 */       if (deployment == null)
/* 617 */         throw new IllegalArgumentException("Null deployment");
/* 618 */       this.deployment = deployment;
/* 619 */       this.lastModified = lastModified;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.scanner.VFSDeploymentScannerImpl
 * JD-Core Version:    0.6.0
 */