/*     */ package org.jboss.deployers.plugins.deployers;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.deployer.Deployer;
/*     */ import org.jboss.deployers.spi.deployer.DeploymentStage;
/*     */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ 
/*     */ public class DeployerWrapper
/*     */   implements Deployer, ManagedObjectCreator
/*     */ {
/*     */   private Logger log;
/*     */   private Deployer deployer;
/*     */   private ManagedObjectCreator managedObjectCreator;
/*     */ 
/*     */   public DeployerWrapper(Deployer deployer)
/*     */   {
/*  62 */     if (deployer == null)
/*  63 */       throw new IllegalArgumentException("Null deployer");
/*  64 */     this.deployer = deployer;
/*  65 */     if ((deployer instanceof ManagedObjectCreator))
/*  66 */       this.managedObjectCreator = ((ManagedObjectCreator)deployer);
/*  67 */     this.log = Logger.getLogger(deployer.getClass());
/*     */   }
/*     */ 
/*     */   public ManagedObjectCreator getManagedObjectCreator()
/*     */   {
/*  77 */     return this.managedObjectCreator;
/*     */   }
/*     */ 
/*     */   public void setManagedObjectCreator(ManagedObjectCreator managedObjectCreator)
/*     */   {
/*  87 */     this.managedObjectCreator = managedObjectCreator;
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/*  92 */     return this.deployer.getType();
/*     */   }
/*     */ 
/*     */   public int getRelativeOrder()
/*     */   {
/*  97 */     return this.deployer.getRelativeOrder();
/*     */   }
/*     */ 
/*     */   public void setRelativeOrder(int order)
/*     */   {
/* 102 */     this.deployer.setRelativeOrder(order);
/*     */   }
/*     */ 
/*     */   public boolean isAllInputs()
/*     */   {
/* 107 */     return this.deployer.isAllInputs();
/*     */   }
/*     */ 
/*     */   public boolean isComponentsOnly()
/*     */   {
/* 112 */     return this.deployer.isComponentsOnly();
/*     */   }
/*     */ 
/*     */   public boolean isWantComponents()
/*     */   {
/* 117 */     return this.deployer.isWantComponents();
/*     */   }
/*     */ 
/*     */   public boolean isTopLevelOnly()
/*     */   {
/* 122 */     return this.deployer.isTopLevelOnly();
/*     */   }
/*     */ 
/*     */   public Class<?> getInput()
/*     */   {
/* 127 */     return this.deployer.getInput();
/*     */   }
/*     */ 
/*     */   public Class<?> getOutput()
/*     */   {
/* 132 */     return this.deployer.getOutput();
/*     */   }
/*     */ 
/*     */   public Set<String> getInputs()
/*     */   {
/* 137 */     Set result = this.deployer.getInputs();
/* 138 */     if (result == null)
/* 139 */       return Collections.emptySet();
/* 140 */     return result;
/*     */   }
/*     */ 
/*     */   public Set<String> getOutputs()
/*     */   {
/* 145 */     Set result = this.deployer.getOutputs();
/* 146 */     if (result == null)
/* 147 */       return Collections.emptySet();
/* 148 */     return result;
/*     */   }
/*     */ 
/*     */   public DeploymentStage getStage()
/*     */   {
/* 153 */     return this.deployer.getStage();
/*     */   }
/*     */ 
/*     */   public boolean isParentFirst()
/*     */   {
/* 158 */     return this.deployer.isParentFirst();
/*     */   }
/*     */ 
/*     */   public void deploy(DeploymentUnit unit) throws DeploymentException
/*     */   {
/* 163 */     if (unit == null) {
/* 164 */       throw new IllegalArgumentException("Null unit");
/*     */     }
/*     */     try
/*     */     {
/* 168 */       this.log.trace("Deploying: " + unit.getName());
/* 169 */       this.deployer.deploy(unit);
/* 170 */       this.log.trace("Deployed:  " + unit.getName());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 174 */       this.log.debug("Error during deploy: " + unit.getName(), t);
/* 175 */       throw DeploymentException.rethrowAsDeploymentException("Error during deploy: " + unit.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void undeploy(DeploymentUnit unit)
/*     */   {
/* 181 */     if (unit == null) {
/* 182 */       throw new IllegalArgumentException("Null unit");
/*     */     }
/*     */     try
/*     */     {
/* 186 */       this.log.trace("Undeploying: " + unit.getName());
/* 187 */       this.deployer.undeploy(unit);
/* 188 */       this.log.trace("Undeployed:  " + unit.getName());
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 192 */       this.log.error("Error during undeploy: " + unit.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 200 */       ManagedObjectCreator creator = getManagedObjectCreator();
/* 201 */       if (creator != null)
/* 202 */         creator.build(unit, managedObjects);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 206 */       throw DeploymentException.rethrowAsDeploymentException("Error building managed objects for " + unit.getName(), t);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 213 */     if (obj == this)
/* 214 */       return true;
/* 215 */     if ((obj == null) || (!(obj instanceof ManagedObjectCreator)))
/* 216 */       return false;
/* 217 */     if ((obj instanceof DeployerWrapper))
/* 218 */       obj = ((DeployerWrapper)obj).deployer;
/* 219 */     return this.deployer.equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 225 */     return this.deployer.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 231 */     return this.deployer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.deployers.DeployerWrapper
 * JD-Core Version:    0.6.0
 */