/*     */ package org.jboss.deployers.plugins.classloading;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.classloading.Capability;
/*     */ import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
/*     */ import org.jboss.deployers.structure.spi.classloading.Requirement;
/*     */ 
/*     */ public class Domain
/*     */ {
/*     */   private String name;
/*  47 */   private Map<DeploymentUnit, Module> units = new ConcurrentHashMap();
/*     */ 
/*     */   public Domain(String name)
/*     */   {
/*  57 */     if (name == null)
/*  58 */       throw new IllegalArgumentException("Null name");
/*  59 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  69 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void addDeploymentUnit(DeploymentUnit deploymentUnit, ClassLoaderMetaData metadata)
/*     */   {
/*  81 */     Module module = new Module(this, deploymentUnit, metadata);
/*  82 */     deploymentUnit.addAttachment(Module.class, module);
/*  83 */     this.units.put(deploymentUnit, module);
/*  84 */     module.createDependencies();
/*     */   }
/*     */ 
/*     */   protected Module getModule(String name)
/*     */   {
/*  95 */     for (Module module : this.units.values())
/*     */     {
/*  97 */       if (name.equals(module.getName()))
/*  98 */         return module;
/*     */     }
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   protected Object resolve(Controller controller, Module module, Requirement requirement)
/*     */   {
/* 114 */     for (Iterator i$ = this.units.values().iterator(); i$.hasNext(); ) { other = (Module)i$.next();
/*     */ 
/* 116 */       ClassLoaderMetaData metadata = other.getMetadata();
/* 117 */       List capabilities = metadata.getCapabilities();
/* 118 */       if (capabilities != null)
/*     */       {
/* 120 */         for (Capability capability : capabilities)
/*     */         {
/* 122 */           if (capability.resolves(module.getDeploymentUnit(), requirement))
/* 123 */             return other.getName();
/*     */         }
/*     */       }
/*     */     }
/*     */     Module other;
/* 127 */     return null;
/*     */   }
/*     */ 
/*     */   protected void removeModule(Module module)
/*     */   {
/* 138 */     if (module == null)
/* 139 */       throw new IllegalArgumentException("Null module");
/* 140 */     DeploymentUnit unit = module.getDeploymentUnit();
/* 141 */     this.units.remove(unit);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.classloading.Domain
 * JD-Core Version:    0.6.0
 */