/*     */ package org.jboss.deployers.plugins.attachments;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.atomic.AtomicInteger;
/*     */ import org.jboss.deployers.spi.attachments.helpers.AbstractMutableAttachments;
/*     */ 
/*     */ public class AttachmentsImpl extends AbstractMutableAttachments
/*     */ {
/*     */   private static final long serialVersionUID = 8078990023620470935L;
/*  46 */   private Map<String, Object> attachments = new ConcurrentHashMap();
/*     */ 
/*  49 */   private AtomicInteger changeCount = new AtomicInteger();
/*     */ 
/*     */   public Map<String, Object> getAttachments()
/*     */   {
/*  53 */     return Collections.unmodifiableMap(this.attachments);
/*     */   }
/*     */ 
/*     */   public void setAttachments(Map<String, Object> map)
/*     */   {
/*  59 */     if (map == null) {
/*  60 */       throw new IllegalArgumentException("Null map");
/*     */     }
/*  62 */     this.attachments.clear();
/*  63 */     this.attachments.putAll(map);
/*  64 */     this.changeCount.addAndGet(map.size());
/*     */   }
/*     */ 
/*     */   public Object addAttachment(String name, Object attachment)
/*     */   {
/*  69 */     if (name == null)
/*  70 */       throw new IllegalArgumentException("Null name");
/*  71 */     if (attachment == null)
/*  72 */       throw new IllegalArgumentException("Null attachment");
/*  73 */     Object value = this.attachments.put(name, attachment);
/*  74 */     this.changeCount.incrementAndGet();
/*  75 */     return value;
/*     */   }
/*     */ 
/*     */   public Object getAttachment(String name)
/*     */   {
/*  80 */     if (name == null)
/*  81 */       throw new IllegalArgumentException("Null name");
/*  82 */     return this.attachments.get(name);
/*     */   }
/*     */ 
/*     */   public boolean isAttachmentPresent(String name)
/*     */   {
/*  87 */     if (name == null)
/*  88 */       throw new IllegalArgumentException("Null name");
/*  89 */     return this.attachments.containsKey(name);
/*     */   }
/*     */ 
/*     */   public Object removeAttachment(String name)
/*     */   {
/*  94 */     if (name == null)
/*  95 */       throw new IllegalArgumentException("Null name");
/*  96 */     Object value = this.attachments.remove(name);
/*  97 */     this.changeCount.incrementAndGet();
/*  98 */     return value;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 103 */     this.attachments.clear();
/* 104 */     this.changeCount.incrementAndGet();
/*     */   }
/*     */ 
/*     */   public boolean hasAttachments()
/*     */   {
/* 109 */     return !this.attachments.isEmpty();
/*     */   }
/*     */ 
/*     */   public int getChangeCount()
/*     */   {
/* 114 */     return this.changeCount.intValue();
/*     */   }
/*     */ 
/*     */   public void clearChangeCount()
/*     */   {
/* 119 */     this.changeCount.set(0);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 125 */     return this.attachments.toString();
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 131 */     super.readExternal(in);
/* 132 */     setAttachments((Map)in.readObject());
/* 133 */     this.changeCount.set(in.read());
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 144 */     super.writeExternal(out);
/* 145 */     out.writeObject(getAttachments());
/* 146 */     out.write(this.changeCount.get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.plugins.attachments.AttachmentsImpl
 * JD-Core Version:    0.6.0
 */