/*     */ package org.jboss.deployers.client.spi;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.TreeMap;
/*     */ import java.util.TreeSet;
/*     */ 
/*     */ public class IncompleteDeployments
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -8413355643801749950L;
/*     */   private Map<String, Throwable> deploymentsInError;
/*     */   private Collection<String> deploymentsMissingDeployer;
/*     */   private Map<String, Throwable> contextsInError;
/*     */   private Map<String, Set<MissingDependency>> contextsMissingDependencies;
/*     */   private String deploymentsInErrorInfo;
/*     */   private String deploymentsMissingDeployerInfo;
/*     */   private String contextsInErrorInfo;
/*     */   private String contextsMissingDependenciesInfo;
/*     */ 
/*     */   public IncompleteDeployments(Map<String, Throwable> deploymentsInError, Collection<String> deploymentsMissingDeployer, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies)
/*     */   {
/*  78 */     if ((deploymentsInError != null) && (!deploymentsInError.isEmpty()))
/*     */     {
/*  80 */       this.deploymentsInError = new TreeMap();
/*  81 */       this.deploymentsInError.putAll(deploymentsInError);
/*     */     }
/*  83 */     if ((deploymentsMissingDeployer != null) && (!deploymentsMissingDeployer.isEmpty()))
/*     */     {
/*  85 */       this.deploymentsMissingDeployer = new TreeSet();
/*  86 */       this.deploymentsMissingDeployer.addAll(deploymentsMissingDeployer);
/*     */     }
/*  88 */     if ((contextsInError != null) && (!contextsInError.isEmpty()))
/*     */     {
/*  90 */       this.contextsInError = new TreeMap();
/*  91 */       this.contextsInError.putAll(contextsInError);
/*     */     }
/*  93 */     if ((contextsMissingDependencies != null) && (!contextsMissingDependencies.isEmpty()))
/*     */     {
/*  95 */       this.contextsMissingDependencies = new TreeMap();
/*  96 */       this.contextsMissingDependencies.putAll(contextsMissingDependencies);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isIncomplete()
/*     */   {
/* 107 */     if (this.deploymentsInError != null)
/* 108 */       return true;
/* 109 */     if (this.deploymentsMissingDeployer != null)
/* 110 */       return true;
/* 111 */     if (this.contextsInError != null) {
/* 112 */       return true;
/*     */     }
/* 114 */     return this.contextsMissingDependencies != null;
/*     */   }
/*     */ 
/*     */   public boolean isInvalidDeployment(String deploymentName)
/*     */   {
/* 126 */     if (!isIncomplete()) {
/* 127 */       return false;
/*     */     }
/* 129 */     if (matchComponentName(deploymentName, getDeploymentsInError().keySet())) {
/* 130 */       return true;
/*     */     }
/* 132 */     return matchComponentName(deploymentName, getDeploymentsMissingDeployer());
/*     */   }
/*     */ 
/*     */   public boolean isInvalidContext(String contextName)
/*     */   {
/* 145 */     if (!isIncomplete()) {
/* 146 */       return false;
/*     */     }
/* 148 */     if (matchComponentName(contextName, getContextsInError().keySet())) {
/* 149 */       return true;
/*     */     }
/* 151 */     return matchComponentName(contextName, getContextsMissingDependencies().keySet());
/*     */   }
/*     */ 
/*     */   public String getDeploymentsInErrorInfo()
/*     */   {
/* 163 */     if (this.deploymentsInErrorInfo == null)
/*     */     {
/* 165 */       StringBuilder buffer = new StringBuilder();
/*     */ 
/* 167 */       Map deploymentsInError = getDeploymentsInError();
/* 168 */       if (!deploymentsInError.isEmpty())
/*     */       {
/* 170 */         buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n\n");
/* 171 */         for (Map.Entry entry : deploymentsInError.entrySet())
/* 172 */           buffer.append((String)entry.getKey()).append(" -> ").append(((Throwable)entry.getValue()).toString()).append("\n\n");
/*     */       }
/* 174 */       this.deploymentsInErrorInfo = buffer.toString();
/*     */     }
/* 176 */     return this.deploymentsInErrorInfo;
/*     */   }
/*     */ 
/*     */   public String getDeploymentsMissingDeployerInfo()
/*     */   {
/* 186 */     if (this.deploymentsMissingDeployerInfo == null)
/*     */     {
/* 188 */       StringBuilder buffer = new StringBuilder();
/*     */ 
/* 190 */       Collection deploymentsMissingDeployers = getDeploymentsMissingDeployer();
/* 191 */       if (!deploymentsMissingDeployers.isEmpty())
/*     */       {
/* 193 */         buffer.append("\n*** DEPLOYMENTS MISSING DEPLOYERS: Name\n\n");
/* 194 */         for (String name : deploymentsMissingDeployers)
/* 195 */           buffer.append(name).append('\n');
/*     */       }
/* 197 */       this.deploymentsMissingDeployerInfo = buffer.toString();
/*     */     }
/* 199 */     return this.deploymentsMissingDeployerInfo;
/*     */   }
/*     */ 
/*     */   protected void calculateContextsError()
/*     */   {
/* 208 */     Map rootCauses = new HashMap();
/*     */ 
/* 211 */     Map contextsMissingDependencies = getContextsMissingDependencies();
/* 212 */     if (!contextsMissingDependencies.isEmpty())
/*     */     {
/* 214 */       for (Map.Entry entry : contextsMissingDependencies.entrySet())
/*     */       {
/* 216 */         for (MissingDependency dependency : (Set)entry.getValue()) {
/* 217 */           rootCauses.put(dependency.getDependency(), dependency.getActualState());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 222 */     Map contextsInError = getContextsInError();
/* 223 */     if (!contextsInError.isEmpty())
/*     */     {
/* 225 */       for (Map.Entry entry : contextsInError.entrySet())
/*     */       {
/* 227 */         Throwable t = (Throwable)entry.getValue();
/* 228 */         if (t == null)
/* 229 */           rootCauses.put(entry.getKey(), "** UNKNOWN ERROR **");
/*     */         else {
/* 231 */           rootCauses.put(entry.getKey(), t.toString());
/*     */         }
/*     */       }
/*     */     }
/* 235 */     StringBuilder buffer = new StringBuilder();
/*     */ 
/* 238 */     if (!contextsMissingDependencies.isEmpty())
/*     */     {
/* 240 */       buffer.append("\n*** CONTEXTS MISSING DEPENDENCIES: Name -> Dependency{Required State:Actual State}\n\n");
/* 241 */       for (Map.Entry entry : contextsMissingDependencies.entrySet())
/*     */       {
/* 243 */         String name = (String)entry.getKey();
/* 244 */         buffer.append(name).append("\n");
/* 245 */         for (MissingDependency dependency : (Set)entry.getValue())
/*     */         {
/* 247 */           buffer.append(" -> ").append(dependency.getDependency());
/* 248 */           buffer.append('{').append(dependency.getRequiredState());
/* 249 */           buffer.append(':').append(dependency.getActualState()).append("}");
/* 250 */           buffer.append("\n");
/*     */         }
/* 252 */         buffer.append('\n');
/*     */ 
/* 255 */         rootCauses.remove(name);
/*     */       }
/*     */     }
/* 258 */     this.contextsMissingDependenciesInfo = buffer.toString();
/*     */ 
/* 261 */     buffer.setLength(0);
/*     */ 
/* 263 */     if (!rootCauses.isEmpty())
/*     */     {
/* 265 */       buffer.append("\n*** CONTEXTS IN ERROR: Name -> Error\n\n");
/* 266 */       for (Map.Entry entry : rootCauses.entrySet())
/* 267 */         buffer.append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n\n");
/*     */     }
/* 269 */     this.contextsInErrorInfo = buffer.toString();
/*     */   }
/*     */ 
/*     */   public String getContextsInErrorInfo()
/*     */   {
/* 279 */     if (this.contextsInErrorInfo == null) {
/* 280 */       calculateContextsError();
/*     */     }
/* 282 */     return this.contextsInErrorInfo;
/*     */   }
/*     */ 
/*     */   public String getContextsMissingDependenciesInfo()
/*     */   {
/* 291 */     if (this.contextsMissingDependenciesInfo == null) {
/* 292 */       calculateContextsError();
/*     */     }
/* 294 */     return this.contextsMissingDependenciesInfo;
/*     */   }
/*     */ 
/*     */   protected boolean matchComponentName(String componentName, Collection<String> strings)
/*     */   {
/* 306 */     return strings.contains(componentName);
/*     */   }
/*     */ 
/*     */   public Map<String, Throwable> getContextsInError()
/*     */   {
/* 316 */     if (this.contextsInError == null) {
/* 317 */       return Collections.emptyMap();
/*     */     }
/* 319 */     return Collections.unmodifiableMap(this.contextsInError);
/*     */   }
/*     */ 
/*     */   public Map<String, Set<MissingDependency>> getContextsMissingDependencies()
/*     */   {
/* 329 */     if (this.contextsMissingDependencies == null) {
/* 330 */       return Collections.emptyMap();
/*     */     }
/* 332 */     return Collections.unmodifiableMap(this.contextsMissingDependencies);
/*     */   }
/*     */ 
/*     */   public Map<String, Throwable> getDeploymentsInError()
/*     */   {
/* 342 */     if (this.deploymentsInError == null) {
/* 343 */       return Collections.emptyMap();
/*     */     }
/* 345 */     return Collections.unmodifiableMap(this.deploymentsInError);
/*     */   }
/*     */ 
/*     */   public Collection<String> getDeploymentsMissingDeployer()
/*     */   {
/* 355 */     if (this.deploymentsMissingDeployer == null) {
/* 356 */       return Collections.emptySet();
/*     */     }
/* 358 */     return Collections.unmodifiableCollection(this.deploymentsMissingDeployer);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.client.spi.IncompleteDeployments
 * JD-Core Version:    0.6.0
 */