/*    */ package org.jboss.deployers.client.spi;
/*    */ 
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ 
/*    */ public class IncompleteDeploymentException extends DeploymentException
/*    */ {
/*    */   private static final long serialVersionUID = 1433292979582684692L;
/*    */   private IncompleteDeployments incompleteDeployments;
/*    */ 
/*    */   public IncompleteDeploymentException()
/*    */   {
/*    */   }
/*    */ 
/*    */   public IncompleteDeploymentException(IncompleteDeployments incompleteDeployments)
/*    */   {
/* 55 */     if (incompleteDeployments == null)
/* 56 */       throw new IllegalArgumentException("Null incompleteDeployments");
/* 57 */     this.incompleteDeployments = incompleteDeployments;
/*    */   }
/*    */ 
/*    */   public IncompleteDeployments getIncompleteDeployments()
/*    */   {
/* 67 */     return this.incompleteDeployments;
/*    */   }
/*    */ 
/*    */   public String getMessage()
/*    */   {
/* 73 */     StringBuilder buffer = new StringBuilder();
/* 74 */     buffer.append("Summary of incomplete deployments (SEE PREVIOUS ERRORS FOR DETAILS):\n");
/*    */ 
/* 76 */     buffer.append(this.incompleteDeployments.getDeploymentsMissingDeployerInfo());
/*    */ 
/* 78 */     buffer.append(this.incompleteDeployments.getDeploymentsInErrorInfo());
/*    */ 
/* 80 */     buffer.append(this.incompleteDeployments.getContextsMissingDependenciesInfo());
/*    */ 
/* 82 */     buffer.append(this.incompleteDeployments.getContextsInErrorInfo());
/*    */ 
/* 84 */     return buffer.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.client.spi.IncompleteDeploymentException
 * JD-Core Version:    0.6.0
 */