/*     */ package org.jboss.deployers.client.spi;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.deployers.spi.attachments.AttachmentsFactory;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
/*     */ import org.jboss.deployers.spi.structure.ClassPathEntry;
/*     */ import org.jboss.deployers.spi.structure.ContextInfo;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaData;
/*     */ import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
/*     */ 
/*     */ public class DeploymentFactory
/*     */ {
/*     */   public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path)
/*     */   {
/*  55 */     StructureMetaData structure = assureStructure(context);
/*  56 */     ContextInfo result = StructureMetaDataFactory.createContextInfo(path);
/*  57 */     structure.addContext(result);
/*  58 */     return result;
/*     */   }
/*     */ 
/*     */   public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, List<ClassPathEntry> classPath)
/*     */   {
/*  72 */     StructureMetaData structure = assureStructure(context);
/*  73 */     ContextInfo result = StructureMetaDataFactory.createContextInfo(path, classPath);
/*  74 */     structure.addContext(result);
/*  75 */     return result;
/*     */   }
/*     */ 
/*     */   public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, String metaDataPath, List<ClassPathEntry> classPath)
/*     */   {
/*  90 */     StructureMetaData structure = assureStructure(context);
/*  91 */     ContextInfo result = StructureMetaDataFactory.createContextInfo(path, metaDataPath, classPath);
/*  92 */     structure.addContext(result);
/*  93 */     return result;
/*     */   }
/*     */ 
/*     */   public ContextInfo addContext(PredeterminedManagedObjectAttachments context, String path, List<String> metaDataPath, List<ClassPathEntry> classPath)
/*     */   {
/* 108 */     StructureMetaData structure = assureStructure(context);
/* 109 */     ContextInfo result = StructureMetaDataFactory.createContextInfo(path, metaDataPath, classPath);
/* 110 */     structure.addContext(result);
/* 111 */     return result;
/*     */   }
/*     */ 
/*     */   public static ClassPathEntry createClassPathEntry(String path)
/*     */   {
/* 123 */     return StructureMetaDataFactory.createClassPathEntry(path, null);
/*     */   }
/*     */ 
/*     */   public static List<ClassPathEntry> createClassPath(String path)
/*     */   {
/* 135 */     return Collections.singletonList(createClassPathEntry(path));
/*     */   }
/*     */ 
/*     */   public static ClassPathEntry createClassPathEntry(String path, String suffixes)
/*     */   {
/* 148 */     return StructureMetaDataFactory.createClassPathEntry(path, suffixes);
/*     */   }
/*     */ 
/*     */   public static List<ClassPathEntry> createClassPath(String path, String suffixes)
/*     */   {
/* 161 */     return Collections.singletonList(createClassPathEntry(path, suffixes));
/*     */   }
/*     */ 
/*     */   protected static StructureMetaData assureStructure(PredeterminedManagedObjectAttachments context)
/*     */   {
/* 172 */     if (context == null) {
/* 173 */       throw new IllegalArgumentException("Null context");
/*     */     }
/*     */ 
/* 177 */     Attachments attachments = context.getPredeterminedManagedObjects();
/*     */     MutableAttachments mutable;
/* 180 */     if (attachments == null)
/*     */     {
/* 182 */       MutableAttachments mutable = AttachmentsFactory.createMutableAttachments();
/* 183 */       context.setPredeterminedManagedObjects(mutable);
/*     */     }
/* 186 */     else if (!(attachments instanceof MutableAttachments))
/*     */     {
/* 188 */       MutableAttachments mutable = AttachmentsFactory.createMutableAttachments();
/* 189 */       Map map = attachments.getAttachments();
/* 190 */       if (map != null)
/* 191 */         mutable.setAttachments(map);
/* 192 */       context.setPredeterminedManagedObjects(mutable);
/*     */     }
/*     */     else
/*     */     {
/* 196 */       mutable = (MutableAttachments)attachments;
/*     */     }
/*     */ 
/* 199 */     StructureMetaData structure = (StructureMetaData)mutable.getAttachment(StructureMetaData.class);
/*     */ 
/* 201 */     if (structure == null)
/*     */     {
/* 203 */       structure = StructureMetaDataFactory.createStructureMetaData();
/* 204 */       mutable.addAttachment(StructureMetaData.class, structure);
/*     */     }
/* 206 */     return structure;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.client.spi.DeploymentFactory
 * JD-Core Version:    0.6.0
 */