package org.jboss.deployers.client.spi;

import java.util.Collection;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.util.graph.Graph;

public abstract interface DeployerClient
{
  public abstract Collection<Deployment> getTopLevel();

  public abstract Deployment getDeployment(String paramString);

  public abstract void addDeployment(Deployment paramDeployment)
    throws DeploymentException;

  public abstract boolean removeDeployment(Deployment paramDeployment)
    throws DeploymentException;

  public abstract boolean removeDeployment(String paramString)
    throws DeploymentException;

  public abstract void process();

  public abstract void deploy(Deployment[] paramArrayOfDeployment)
    throws DeploymentException;

  public abstract void undeploy(Deployment[] paramArrayOfDeployment)
    throws DeploymentException;

  public abstract void checkComplete()
    throws DeploymentException;

  public abstract void checkComplete(Deployment[] paramArrayOfDeployment)
    throws DeploymentException;

  public abstract void checkComplete(String[] paramArrayOfString)
    throws DeploymentException;

  public abstract void checkStructureComplete(Deployment[] paramArrayOfDeployment)
    throws DeploymentException;

  public abstract void checkStructureComplete(String[] paramArrayOfString)
    throws DeploymentException;

  public abstract void undeploy(String[] paramArrayOfString)
    throws DeploymentException;

  public abstract DeploymentState getDeploymentState(String paramString);

  public abstract Map<String, ManagedObject> getManagedObjects(String paramString)
    throws DeploymentException;

  public abstract Graph<Map<String, ManagedObject>> getDeepManagedObjects(String paramString)
    throws DeploymentException;

  public abstract ManagedDeployment getManagedDeployment(String paramString)
    throws DeploymentException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.client.spi.DeployerClient
 * JD-Core Version:    0.6.0
 */