/*     */ package org.jboss.deployers.client.plugins.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Set;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.spi.attachments.helpers.PredeterminedManagedObjectAttachmentsImpl;
/*     */ 
/*     */ public class AbstractDeployment extends PredeterminedManagedObjectAttachmentsImpl
/*     */   implements Deployment
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   private String name;
/*     */   private Set<String> types;
/*     */ 
/*     */   public AbstractDeployment()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AbstractDeployment(String name)
/*     */   {
/*  63 */     setName(name);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  73 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */   {
/*  83 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/*  94 */     if (name == null)
/*  95 */       throw new IllegalArgumentException("Null name");
/*  96 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public Set<String> getTypes()
/*     */   {
/* 101 */     return this.types;
/*     */   }
/*     */ 
/*     */   public void setTypes(Set<String> types) {
/* 105 */     this.types = types;
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/* 110 */     super.readExternal(in);
/* 111 */     boolean hasName = in.readBoolean();
/* 112 */     if (hasName)
/* 113 */       this.name = in.readUTF();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 123 */     super.writeExternal(out);
/* 124 */     String name = getName();
/* 125 */     out.writeBoolean(name != null);
/* 126 */     if (name != null)
/* 127 */       out.writeUTF(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.deployers.client.plugins.deployment.AbstractDeployment
 * JD-Core Version:    0.6.0
 */