/*     */ package org.jboss.dependency.spi.helpers;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.LifecycleCallbackItem;
/*     */ import org.jboss.util.JBossObject;
/*     */ 
/*     */ public class UnmodifiableDependencyInfo extends JBossObject
/*     */   implements DependencyInfo
/*     */ {
/*     */   private DependencyInfo delegate;
/*     */ 
/*     */   public UnmodifiableDependencyInfo(DependencyInfo delegate)
/*     */   {
/*  46 */     if (delegate == null)
/*  47 */       throw new IllegalArgumentException("Null dependency info!");
/*  48 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Set<DependencyItem> getIDependOn(Class<?> type)
/*     */   {
/*  53 */     return this.delegate.getIDependOn(type);
/*     */   }
/*     */ 
/*     */   public Set<DependencyItem> getDependsOnMe(Class<?> type)
/*     */   {
/*  58 */     return this.delegate.getDependsOnMe(type);
/*     */   }
/*     */ 
/*     */   public void addIDependOn(DependencyItem dependency)
/*     */   {
/*  63 */     throw new UnsupportedOperationException("Cannot execute add on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public void removeIDependOn(DependencyItem dependency)
/*     */   {
/*  68 */     throw new UnsupportedOperationException("Cannot execute remove on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public void addDependsOnMe(DependencyItem dependency)
/*     */   {
/*  73 */     throw new UnsupportedOperationException("Cannot execute add on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public void removeDependsOnMe(DependencyItem dependency)
/*     */   {
/*  78 */     throw new UnsupportedOperationException("Cannot execute remove on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public boolean resolveDependencies(Controller controller, ControllerState state)
/*     */   {
/*  83 */     return this.delegate.resolveDependencies(controller, state);
/*     */   }
/*     */ 
/*     */   public Set<DependencyItem> getUnresolvedDependencies()
/*     */   {
/*  88 */     return this.delegate.getUnresolvedDependencies();
/*     */   }
/*     */ 
/*     */   public <T> void addInstallItem(CallbackItem<T> callbackItem)
/*     */   {
/*  93 */     throw new UnsupportedOperationException("Cannot execute add on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public <T> void removeInstallItem(CallbackItem<T> callbackItem)
/*     */   {
/*  98 */     throw new UnsupportedOperationException("Cannot execute remove on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public Set<CallbackItem<?>> getInstallItems()
/*     */   {
/* 103 */     return this.delegate.getInstallItems();
/*     */   }
/*     */ 
/*     */   public <T> void addUninstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 108 */     throw new UnsupportedOperationException("Cannot execute add on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public <T> void removeUninstallItem(CallbackItem<T> callbackItem)
/*     */   {
/* 113 */     throw new UnsupportedOperationException("Cannot execute remove on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public Set<CallbackItem<?>> getUninstallItems()
/*     */   {
/* 118 */     return this.delegate.getUninstallItems();
/*     */   }
/*     */ 
/*     */   public void addLifecycleCallback(LifecycleCallbackItem lifecycleCallbackItem)
/*     */   {
/* 123 */     throw new UnsupportedOperationException("Cannot execute add on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public List<LifecycleCallbackItem> getLifecycleCallbacks()
/*     */   {
/* 128 */     return this.delegate.getLifecycleCallbacks();
/*     */   }
/*     */ 
/*     */   public boolean isAutowireCandidate()
/*     */   {
/* 133 */     return this.delegate.isAutowireCandidate();
/*     */   }
/*     */ 
/*     */   public void setAutowireCandidate(boolean candidate)
/*     */   {
/* 138 */     throw new UnsupportedOperationException("Cannot execute set on unmodifiable wrapper.");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.helpers.UnmodifiableDependencyInfo
 * JD-Core Version:    0.6.0
 */