/*     */ package org.jboss.dependency.spi.helpers;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.ScopeInfo;
/*     */ import org.jboss.util.JBossObject;
/*     */ 
/*     */ public class UnmodifiableControllerContext<T extends ControllerContext> extends JBossObject
/*     */   implements ControllerContext
/*     */ {
/*     */   protected T delegate;
/*     */ 
/*     */   public UnmodifiableControllerContext(T delegate)
/*     */   {
/*  47 */     if (delegate == null)
/*  48 */       throw new IllegalArgumentException("Null delegate");
/*  49 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Object getName()
/*     */   {
/*  54 */     return this.delegate.getName();
/*     */   }
/*     */ 
/*     */   public Set<Object> getAliases()
/*     */   {
/*  59 */     Set aliases = this.delegate.getAliases();
/*  60 */     return aliases != null ? Collections.unmodifiableSet(aliases) : null;
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/*  65 */     DependencyInfo dependencyInfo = this.delegate.getDependencyInfo();
/*  66 */     return dependencyInfo != null ? new UnmodifiableDependencyInfo(dependencyInfo) : null;
/*     */   }
/*     */ 
/*     */   public ScopeInfo getScopeInfo()
/*     */   {
/*  71 */     ScopeInfo scopeInfo = this.delegate.getScopeInfo();
/*  72 */     return scopeInfo != null ? new UnmodifiableScopeInfo(scopeInfo) : null;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/*  77 */     return this.delegate.getTarget();
/*     */   }
/*     */ 
/*     */   public Controller getController()
/*     */   {
/*  82 */     return this.delegate.getController();
/*     */   }
/*     */ 
/*     */   public void setController(Controller controller)
/*     */   {
/*  87 */     throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public void install(ControllerState fromState, ControllerState toState) throws Throwable
/*     */   {
/*  92 */     this.delegate.install(fromState, toState);
/*     */   }
/*     */ 
/*     */   public void uninstall(ControllerState fromState, ControllerState toState)
/*     */   {
/*  97 */     this.delegate.uninstall(fromState, toState);
/*     */   }
/*     */ 
/*     */   public ControllerState getState()
/*     */   {
/* 102 */     return this.delegate.getState();
/*     */   }
/*     */ 
/*     */   public void setState(ControllerState state)
/*     */   {
/* 107 */     throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public ControllerState getRequiredState()
/*     */   {
/* 112 */     return this.delegate.getRequiredState();
/*     */   }
/*     */ 
/*     */   public void setRequiredState(ControllerState state)
/*     */   {
/* 117 */     throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 122 */     return this.delegate.getMode();
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 127 */     throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
/*     */   }
/*     */ 
/*     */   public Throwable getError()
/*     */   {
/* 132 */     return this.delegate.getError();
/*     */   }
/*     */ 
/*     */   public void setError(Throwable error)
/*     */   {
/* 137 */     throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.helpers.UnmodifiableControllerContext
 * JD-Core Version:    0.6.0
 */