/*     */ package org.jboss.dependency.spi;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class ControllerMode extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  43 */   public static final ControllerMode AUTOMATIC = new ControllerMode("Automatic");
/*     */ 
/*  46 */   public static final ControllerMode ON_DEMAND = new ControllerMode("On Demand");
/*     */ 
/*  49 */   public static final ControllerMode MANUAL = new ControllerMode("Manual");
/*     */ 
/*  52 */   public static final ControllerMode DISABLED = new ControllerMode("Disabled");
/*     */   protected final String modeString;
/*  57 */   private static Map<String, ControllerMode> values = new HashMap();
/*     */ 
/*     */   public ControllerMode(String modeString)
/*     */   {
/*  74 */     if (modeString == null)
/*  75 */       throw new IllegalArgumentException("Null mode string");
/*  76 */     this.modeString = modeString;
/*     */   }
/*     */ 
/*     */   public String getModeString()
/*     */   {
/*  86 */     return this.modeString;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/*  91 */     if ((object == null) || (!(object instanceof ControllerMode)))
/*  92 */       return false;
/*  93 */     ControllerMode other = (ControllerMode)object;
/*  94 */     return this.modeString.equals(other.modeString);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/*  99 */     buffer.append(this.modeString);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 104 */     return this.modeString.hashCode();
/*     */   }
/*     */ 
/*     */   protected Object readResolve() throws ObjectStreamException
/*     */   {
/* 109 */     return values.get(this.modeString);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  61 */     values.put(AUTOMATIC.getModeString(), AUTOMATIC);
/*  62 */     values.put(ON_DEMAND.getModeString(), ON_DEMAND);
/*  63 */     values.put(MANUAL.getModeString(), MANUAL);
/*  64 */     values.put(DISABLED.getModeString(), DISABLED);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.ControllerMode
 * JD-Core Version:    0.6.0
 */