/*     */ package org.jboss.dependency.spi;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class Cardinality extends JBossObject
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   public static final int INFINITY = -1;
/*  40 */   public static final Cardinality ZERO_TO_ONE = new Cardinality("0..1", 0, 1);
/*  41 */   public static final Cardinality ZERO_TO_MANY = new Cardinality("0..n", 0, -1);
/*  42 */   public static final Cardinality ONE_TO_ONE = new Cardinality("1..1", 1, 1);
/*  43 */   public static final Cardinality ONE_TO_MANY = new Cardinality("1..n", 1, -1);
/*     */ 
/*  45 */   private static Cardinality[] values = { ZERO_TO_ONE, ZERO_TO_MANY, ONE_TO_ONE, ONE_TO_MANY };
/*     */   private String type;
/*     */   private int left;
/*     */   private int right;
/*     */ 
/*     */   private Cardinality(String type, int left, int right)
/*     */   {
/*  59 */     this.type = type;
/*  60 */     this.left = left;
/*  61 */     this.right = right;
/*     */   }
/*     */ 
/*     */   public boolean isInRange(int number)
/*     */   {
/*  72 */     if (((number < 0) || (number < this.left) || (this.left == -1) ? 1 : 0) == 0);
/*  72 */     return (number <= this.right) || (this.right == -1);
/*     */   }
/*     */ 
/*     */   public static Cardinality toCardinality(String type)
/*     */   {
/*  83 */     for (Cardinality c : values)
/*     */     {
/*  85 */       if (c.getType().equals(type))
/*     */       {
/*  87 */         return c;
/*     */       }
/*     */     }
/*  90 */     return fromString(type);
/*     */   }
/*     */ 
/*     */   protected static int getLimitFromString(String limit)
/*     */   {
/*     */     try
/*     */     {
/* 103 */       return Integer.parseInt(limit);
/*     */     }
/*     */     catch (NumberFormatException e) {
/*     */     }
/* 107 */     return -1;
/*     */   }
/*     */ 
/*     */   protected static String getLimitFromInt(int limit)
/*     */   {
/* 119 */     return limit == -1 ? "n" : String.valueOf(limit);
/*     */   }
/*     */ 
/*     */   public static Cardinality fromString(String string)
/*     */   {
/* 130 */     if (string == null) {
/* 131 */       throw new IllegalArgumentException("Null string.");
/*     */     }
/* 133 */     if (string.contains(".."))
/*     */     {
/* 135 */       String[] args = string.split("\\.\\.");
/* 136 */       if ((args == null) || (args.length != 2))
/* 137 */         throw new IllegalArgumentException("Illegal cardinality format: " + string);
/* 138 */       return createCardinality(getLimitFromString(args[0]), getLimitFromString(args[1]));
/*     */     }
/*     */ 
/* 141 */     return createUnlimitedCardinality(getLimitFromString(string));
/*     */   }
/*     */ 
/*     */   public static Cardinality createUnlimitedCardinality(int start)
/*     */   {
/* 153 */     return createCardinality(start, -1);
/*     */   }
/*     */ 
/*     */   public static Cardinality createLimitedCardinality(int end)
/*     */   {
/* 165 */     return createCardinality(0, end);
/*     */   }
/*     */ 
/*     */   public static Cardinality createCardinality(int left, int right)
/*     */   {
/* 177 */     return new Cardinality(getLimitFromInt(left) + ".." + getLimitFromInt(right), left, right);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/* 182 */     return this.type.hashCode();
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 187 */     buffer.append("type=").append(this.type);
/*     */   }
/*     */ 
/*     */   protected void toString(JBossStringBuilder buffer)
/*     */   {
/* 192 */     buffer.append("type=").append(this.type);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 197 */     if (!(obj instanceof Cardinality))
/* 198 */       return false;
/* 199 */     Cardinality card = (Cardinality)obj;
/* 200 */     return (this.left == card.left) && (this.right == card.right);
/*     */   }
/*     */ 
/*     */   public String getType()
/*     */   {
/* 205 */     return this.type;
/*     */   }
/*     */ 
/*     */   public int getLeft()
/*     */   {
/* 210 */     return this.left;
/*     */   }
/*     */ 
/*     */   public int getRight()
/*     */   {
/* 215 */     return this.right;
/*     */   }
/*     */ 
/*     */   public boolean isLeftInfinity()
/*     */   {
/* 220 */     return this.left <= -1;
/*     */   }
/*     */ 
/*     */   public boolean isRightInfinity()
/*     */   {
/* 225 */     return this.right <= -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.spi.Cardinality
 * JD-Core Version:    0.6.0
 */