/*     */ package org.jboss.dependency.plugins.action;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ 
/*     */ public abstract class AccessControllerContextAction<S extends ControllerContext, T extends ControllerContext>
/*     */   implements ControllerContextAction
/*     */ {
/*     */   protected abstract boolean validateContext(ControllerContext paramControllerContext);
/*     */ 
/*     */   protected abstract S simpleContextCast(ControllerContext paramControllerContext);
/*     */ 
/*     */   protected abstract T fullContextCast(ControllerContext paramControllerContext);
/*     */ 
/*     */   public void install(ControllerContext context)
/*     */     throws Throwable
/*     */   {
/*  70 */     if ((System.getSecurityManager() == null) || (!validateContext(context))) {
/*  71 */       simpleInstallAction(simpleContextCast(context));
/*     */     }
/*     */     else {
/*  74 */       PrivilegedExceptionAction action = new PrivilegedExceptionAction(context)
/*     */       {
/*     */         public Object run() throws Exception
/*     */         {
/*     */           try
/*     */           {
/*  80 */             AccessControllerContextAction.this.secureInstallAction(AccessControllerContextAction.this.fullContextCast(this.val$context));
/*  81 */             return null;
/*     */           }
/*     */           catch (RuntimeException e)
/*     */           {
/*  85 */             throw e;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/*  89 */             throw e;
/*     */           }
/*     */           catch (Error e)
/*     */           {
/*  93 */             throw e;
/*     */           }
/*     */           catch (Throwable t) {
/*     */           }
/*  97 */           throw new RuntimeException(t);
/*     */         }
/*     */       };
/*     */       try
/*     */       {
/* 103 */         AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 107 */         throw e.getCause();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void simpleInstallAction(S paramS)
/*     */     throws Throwable;
/*     */ 
/*     */   protected abstract void secureInstallAction(T paramT)
/*     */     throws Throwable;
/*     */ 
/*     */   public void uninstall(ControllerContext context)
/*     */   {
/* 130 */     if ((System.getSecurityManager() == null) || (!validateContext(context))) {
/* 131 */       simpleUninstallAction(simpleContextCast(context));
/*     */     }
/*     */     else {
/* 134 */       PrivilegedAction action = new PrivilegedAction(context)
/*     */       {
/*     */         public Object run()
/*     */         {
/* 138 */           AccessControllerContextAction.this.secureUninstallAction(AccessControllerContextAction.this.fullContextCast(this.val$context));
/* 139 */           return null;
/*     */         }
/*     */       };
/* 142 */       AccessController.doPrivileged(action);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void simpleUninstallAction(S paramS);
/*     */ 
/*     */   protected abstract void secureUninstallAction(T paramT);
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.dependency.plugins.action.AccessControllerContextAction
 * JD-Core Version:    0.6.0
 */